<?php

//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
date_default_timezone_set('Africa/Douala');

require_once __DIR__ . '/_env.php';

$logFile = createLogFile();
$time_start = microtime(true);
$url = CHECKTOO_BASE_URL . '/fr/enregistrementpm/update/queue/pm/pp/status/5';
$curl_options = [
	CURLOPT_TIMEOUT => 1000,
	CURLOPT_SSL_VERIFYHOST => 0,
	CURLOPT_SSL_VERIFYPEER => 0,
];

//while ((microtime(true) - $time_start) <= 3570) {
	$date = date('Y-m-d H:i:s');
	file_put_contents($logFile, sprintf("[%s] ", $date), FILE_APPEND | LOCK_EX);
	$response = curl_get($url, null, $curl_options);
	file_put_contents($logFile, $response . "\r\n", FILE_APPEND | LOCK_EX);
	
//	sleep(10);
//}


// FUNCTIONS

function createLogFile()
{
	$path = __DIR__ . '/logs/' . pathinfo(__FILE__)['filename'] . '-' . date('Y-m-d') . '.log';
	if (!file_exists($path)) {
		$file = fopen($path, "w");
		fclose($file);
	}
	return $path;
}

/**
 * Send a GET requst using cURL
 * @param string $url to request
 * @param array $get values to send
 * @param array $options for cURL
 * @return string
 */
function curl_get($url, array $get = NULL, array $options = array())
{
	$defaults = array(
		CURLOPT_URL => $url . (strpos($url, '?') === FALSE ? '?' : '') . http_build_query($get),
		CURLOPT_HEADER => 0,
		CURLOPT_RETURNTRANSFER => TRUE,
		CURLOPT_TIMEOUT => 4
	);

	$ch = curl_init();
	curl_setopt_array($ch, ($options + $defaults));
	if (!$result = curl_exec($ch)) {
		trigger_error(curl_error($ch));
	}
	curl_close($ch);
	return $result;
}
