<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Intl\Data\Bundle\Compiler\GenrbCompiler;
use Symfony\Component\Intl\Data\Bundle\Writer\JsonBundleWriter;
use Symfony\Component\Intl\Data\Generator\CurrencyDataGenerator;
use Symfony\Component\Intl\Data\Generator\GeneratorConfig;
use Symfony\Component\Intl\Data\Generator\LanguageDataGenerator;
use Symfony\Component\Intl\Data\Generator\LocaleDataGenerator;
use Symfony\Component\Intl\Data\Generator\RegionDataGenerator;
use Symfony\Component\Intl\Data\Generator\ScriptDataGenerator;
use Symfony\Component\Intl\Intl;
use Symfony\Component\Intl\Locale;
use Symfony\Component\Intl\Util\GitRepository;

require_once __DIR__.'/common.php';
require_once __DIR__.'/autoload.php';

$argc = $_SERVER['argc'];
$argv = $_SERVER['argv'];

if ($argc > 3 || 2 === $argc && '-h' === $argv[1]) {
    bailout(<<<'MESSAGE'
Usage: php update-data.php <path/to/icu/source> <path/to/icu/build>

Updates the ICU data for Symfony to the latest version of ICU.

If you downloaded the git repository before, you can pass the path to the
repository source in the first optional argument.

If you also built the repository before, you can pass the directory where that
build is stored in the second parameter. The build directory needs to contain
the subdirectories bin/ and lib/.

For running this script, the intl extension must be loaded and all vendors
must have been installed through composer:

composer install

MESSAGE
    );
}

echo LINE;
echo centered('ICU Resource Bundle Compilation')."\n";
echo LINE;

if (!Intl::isExtensionLoaded()) {
    bailout('The intl extension for PHP is not installed.');
}

if ($argc >= 2) {
    $repoDir = $argv[1];
    $git = new GitRepository($repoDir);

    echo "Using the existing git repository at {$repoDir}.\n";
} else {
    echo "Starting git clone. This may take a while...\n";

    $repoDir = sys_get_temp_dir().'/icu-data';
    $git = GitRepository::download('https://github.com/unicode-org/icu.git', $repoDir);

    echo "Git clone to {$repoDir} complete.\n";
}

$gitTag = $git->getLastTag(function ($tag) {
    return preg_match('#^release-[0-9]{1,}-[0-9]{1}$#', $tag);
});
$shortIcuVersion = strip_minor_versions(preg_replace('#release-([0-9]{1,})-([0-9]{1,})#', '$1.$2', $gitTag));

echo "Checking out `{$gitTag}` for version `{$shortIcuVersion}`...\n";
$git->checkout('tags/'.$gitTag);

$filesystem = new Filesystem();
$sourceDir = $repoDir.'/icu4c/source';

if ($argc >= 3) {
    $buildDir = $argv[2];
} else {
    // Always build genrb so that we can determine the ICU version of the
    // download by running genrb --version
    echo "Building genrb.\n";

    cd($sourceDir);

    echo "Running configure...\n";

    $buildDir = sys_get_temp_dir().'/icu-data/'.$shortIcuVersion.'/build';

    $filesystem->remove($buildDir);
    $filesystem->mkdir($buildDir);

    run('./configure --prefix='.$buildDir.' 2>&1');

    echo "Running make...\n";

    // If the directory "lib" does not exist in the download, create it or we
    // will run into problems when building libicuuc.so.
    $filesystem->mkdir($sourceDir.'/lib');

    // If the directory "bin" does not exist in the download, create it or we
    // will run into problems when building genrb.
    $filesystem->mkdir($sourceDir.'/bin');

    echo '[1/6] libicudata.so...';

    cd($sourceDir.'/stubdata');
    run('make 2>&1 && make install 2>&1');

    echo " ok.\n";

    echo '[2/6] libicuuc.so...';

    cd($sourceDir.'/common');
    run('make 2>&1 && make install 2>&1');

    echo " ok.\n";

    echo '[3/6] libicui18n.so...';

    cd($sourceDir.'/i18n');
    run('make 2>&1 && make install 2>&1');

    echo " ok.\n";

    echo '[4/6] libicutu.so...';

    cd($sourceDir.'/tools/toolutil');
    run('make 2>&1 && make install 2>&1');

    echo " ok.\n";

    echo '[5/6] libicuio.so...';

  FILE0        8  X                         `           H      貙x5ڙx5ڙx5ڙx                              w*    0   p          R     d    貙x貙x貙x貙x                       V A 8 D 5 8 ~ 1       0             x     d    貙x貙x貙x貙x                       v a l u e s - m c c 3 1 0 - m n c 2 0 0 - f r - r C A                   $ I 3 0 0                             h X          "&k$ "&k$ x "&k$                     s t r i n g s . x m l               yG                                                                                                                                                                                                                                                                                                                                                                                                                                       FILE0  S
    &  8                   
  G       `           H      ӍġE#šE#šEӍġE                              Q4i    0   x          Z          ӍġEӍġEӍġEӍġE                        0 8 V 7 K C A Z . t x t                         uuid2
8883320256881491448
adnxs.com/
2147492865
2957625088
30968922
3297619173
30950817
*
icu
ChgI_Mt6EAoYASABKAEwzYnKkQY4AUABSAEQzYnKkQYYAA..
adnxs.com/
2147492865
1261864064
30965841
1626411136
30947736
*
 y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                FILE0  [X     8                             `       