<?php

namespace AMLA\SqrBundle\Repository;

/**
 * RelationAffaireRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class RelationAffaireRepository extends \Doctrine\ORM\EntityRepository
{
    public function getPendingInRelation($fournisseur)
    {
        $qr = $this->createQueryBuilder('i')
            ->join('i.fournisseurEnAffaire','r')
            ->where('r.id = :id')
            ->andWhere('i.isAcceptFinal = :statut')
            ->setParameter('id', $fournisseur->getId())
            ->setParameter('statut', 0)
            ->getQuery()
            ->getResult();
        return $qr;
    }

    public function getToValidateRelations($fournisseur)
    {
        $qr = $this->createQueryBuilder('i')
            ->join('i.fournisseurEnAffaire','s')
            ->where('s.id = :id')
            ->andWhere('i.isAcceptFinal = :statut')
            ->setParameter('id', $fournisseur->getId())
            ->setParameter('statut', 0)
            ->getQuery()
            ->getResult();
        return $qr;
    }

    public function getMyRelations($fournisseur)
    {
        $qr = $this->createQueryBuilder('i')
            ->join('i.fournisseurEnAffaire','s')
            ->join('i.fournisseurInitial','t')
            ->where('s.id = :id')
            ->orWhere('t.id = :id')
            ->andWhere('i.isAcceptFinal = :statut')
            ->setParameter('id', $fournisseur->getId())
            ->setParameter('statut', 1)
            ->getQuery()
            ->getResult();
        return $qr;
    }
    public function getReceiptRelations($fournisseur)
    {

        $qr = $this->createQueryBuilder('i')
                ->join('i.fournisseurEnAffaire','r')
                ->where('r.id = :id')
                ->setParameter('id', $fournisseur->getId())
                ->getQuery()
                ->getResult();
        return $qr;
    }

    public function getRejectedRelations($fournisseur)
    {
        $qr = $this->createQueryBuilder('i')
            ->join('i.fournisseurInitial','s')
            ->where('s.id = :id')
            ->andWhere('i.isAcceptFinal = :statut')
            ->setParameter('id', $fournisseur->getId())
            ->setParameter('statut', 2)
            ->getQuery()
            ->getResult();
        return $qr;
    }

    public function getSentRelations($fournisseur)
    {
        $qr = $this->createQueryBuilder('i')
            ->join('i.fournisseurInitial','s')
            ->where('s.id = :id')
            ->setParameter('id', $fournisseur->getId())
            ->getQuery()
            ->getResult();
        return $qr;
    }

    public function getAcceptedOutRelation($fournisseur)
    {
        $qr = $this->createQueryBuilder('i')
            ->join('i.fournisseurInitial','s')
            ->where('s.id = :id')
            ->andWhere('i.isAcceptFinal = :statut')
            ->setParameter('id', $fournisseur->getId())
            ->setParameter('statut', 1)
            ->getQuery()
            ->getResult();
        return $qr;
    }


    public function getAllSentInvitation($fournisseur){

        $qr = $this->createQueryBuilder('i')
            ->join('i.fournisseurInitial','s')
            ->where('s.id = :id')
            ->setParameter('id', $fournisseur->getId())
            ->getQuery()
            ->getResult();
        return $qr;
    }


    public function getAllInvitation($fournisseur)
    {
        $qr = $this->createQueryBuilder('i')
            ->join('i.fournisseurEnAffaire','r')
            ->join('i.fournisseurInitial','s')
            ->where('r.id = :id')
            ->orWhere('s.id = :id')
            ->setParameter('id', $fournisseur->getId())
            ->getQuery()
            ->getResult();
        return $qr;
    }
}
