<?php

namespace AMLA\SqrBundle\Repository;

/**
 * ReceptionTravauxRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ReceptionTravauxRepository extends \Doctrine\ORM\EntityRepository
{
    public function getTravauxRealises($user){

        $qr = $this->createQueryBuilder('r')
        ->join('r.bonCommande','b')
        ->join('b.soummissionOffre','s')
        ->join('s.fournisseur','f')
        ->where('f.id = :id')
        //->andWhere('r.statut = :statut')
        ->setParameter('id', $user->getId())
        //->setParameter('statut', 1)
        ->orderBy('r.id', 'DESC')
        ->getQuery()
        ->getResult();

        return $qr;
    }

    public function getTravauxCommandes($user){

        $qr = $this->createQueryBuilder('r')
        ->join('r.bonCommande','b')
        ->join('b.soummissionOffre','s')
        ->join('s.offre','o')
        ->join('o.fournisseur','f')
        ->where('f.id = :id')
        //->andWhere('r.statut = :statut')
        ->setParameter('id', $user->getId())
        //->setParameter('statut', 0)
        ->orderBy('r.id', 'DESC')
        ->getQuery()
        ->getResult();

        return $qr;
    }

    public function getFactureNew($user){

        $qr = $this->createQueryBuilder('r')
        ->join('fa.bonCommande','b')
        ->join('b.soummissionOffre','s')
        ->join('s.offre','o')
        ->join('o.fournisseur','f')
        ->where('f.id = :id')
        //->andWhere('b.statut = :statut')
        ->setParameter('id', $user->getId())
        //->setParameter('statut', 1)
        ->orderBy('r.id', 'DESC')
        ->getQuery()
        ->getResult();

        return $qr;
    }

}
