<?php

namespace AMLA\SqrBundle\Repository;

/**
 * InvitationRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class InvitationRepository extends \Doctrine\ORM\EntityRepository
{
    public function getPendingInvitation($user){

        $qr = $this->createQueryBuilder('i')
                ->join('i.receiver','r')
                ->where('r.id = :id')
                //->andWhere('i.statut = :statut')
                ->setParameter('id', $user->getId())
                //->setParameter('statut', 0)
                ->getQuery()
                ->getResult();
        return $qr;
    }

    public function getAcceptInvitation($user){

        $qr = $this->createQueryBuilder('i')
                ->join('i.sender','s')
                ->where('s.id = :id')
                ->andWhere('i.statut = :statut')
                ->setParameter('id', $user->getId())
                ->setParameter('statut', 1)
                ->getQuery()
                ->getResult();
        return $qr;
    }


    public function getAllSentInvitation($user){

        $qr = $this->createQueryBuilder('i')
            ->join('i.sender','s')
            ->where('s.id = :id')
            ->setParameter('id', $user->getId())
            ->getQuery()
            ->getResult();
        return $qr;
    }

    public function getReceiptInvitation($user){

        $qr = $this->createQueryBuilder('i')
                ->join('i.receiver','r')
                ->where('r.id = :id')
                ->setParameter('id', $user->getId())
                ->getQuery()
                ->getResult();
        return $qr;
    }

    public function getAllInvitation($user){

        $qr = $this->createQueryBuilder('i')
                ->join('i.receiver','r')
                ->join('i.sender','s')
                ->where('r.id = :id')
                ->orWhere('s.id = :id')
                ->setParameter('id', $user->getId())
                ->getQuery()
                ->getResult();
        return $qr;
    }
}
