<?php

namespace AMLA\SqrBundle\Repository;

/**
 * FactureRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class FactureRepository extends \Doctrine\ORM\EntityRepository
{
    public function getFactureReceive($user){

        $qr = $this->createQueryBuilder('fa')
        ->join('fa.receptionTravaux','rt')
        ->join('rt.bonCommande','b')
        ->join('b.soummissionOffre','s')
        ->join('s.offre','o')
        ->join('o.fournisseur','f')
        ->where('f.id = :id')
        //->andWhere('fa.statut = :statut')
        ->setParameter('id', $user->getId())
        //->setParameter('statut', 0)
        ->getQuery()
        ->getResult();

        return $qr;
    }

    public function getFactureSent($user){

        $qr = $this->createQueryBuilder('fa')
        ->join('fa.receptionTravaux','rt')
        ->join('rt.bonCommande','b')
        ->join('b.soummissionOffre','s')
        ->join('s.fournisseur','f')
        ->where('f.id = :id')
        ->setParameter('id', $user->getId())
        ->getQuery()
        ->getResult();

        return $qr;
    }

    public function getFactureToValidatePay($user){

        $qr = $this->createQueryBuilder('fa')
        ->join('fa.receptionTravaux','rt')
        ->join('rt.bonCommande','b')
        ->join('b.soummissionOffre','s')
        ->join('s.offre','o')
        ->join('o.fournisseur','f')
        ->where('f.id = :id')
        ->andWhere('fa.statut = 0')
        ->setParameter('id', $user->getId())
        ->getQuery()
        ->getResult();

        return $qr;
    }
}
