<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;

class SubscriptionInBillType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('months', ChoiceType::class, array(
            'required' => true,
            'mapped' => true,
            'label' => 'Durée de la souscription',
            'multiple' => false,
            'expanded' => false,
            'choices'  => array(
                'Sélectionner' => '',
                '1 mois' => '1',
                '2 mois' => '2',
                '3 mois' => '3',
                '4 mois' => '4',
                '5 mois' => '5',
                '6 mois' => '6',
                '7 mois' => '7',
                '8 mois' => '8',
                '9 mois' => '9',
                '10 mois' => '10',
                '11 mois' => '11',
                '12 mois' => '12',
            ),
            'attr' => array(
                'class' => 'month'
            )
        ))
        ->add('amount', IntegerType ::class, array(
                'label' => 'Montant de la souscription (FCFA)',     
                'attr'=>array('min'=>0),
                'attr' => array(
                    'readonly' => true,
                ),
        ))
        //->add('dateStart')
        //->add('dateEnd')
        //->add('dateCreated')
        //->add('status')
        //->add('inbill')
        //->add('account')
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\SubscriptionInBill'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_subscriptioninbill';
    }


}
