<?php

namespace AMLA\SqrBundle\Form;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage;

class SoummissionOffreType1 extends AbstractType
{
    /**
     * {@inheritdoc}
     */

    protected $tokenStorage;
    protected $em;
    protected $fournisseur;

    /* public function __construct()
    {
        $this->tokenStorage = new TokenStorage();
        $this->em = new EntityManager();
        $user = $this->tokenStorage->getToken()->getUser();
        $this->fournisseur = $this->em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
    } */

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        
        ->add('pays', EntityType::class,array(
            'class' => 'AMLASqrBundle:Pays',
            //'choices' => array('Rechercher par pays'=>''),
            'placeholder' => 'Rechercher par pays',
            'choice_label' => 'nomFr',
            'mapped'=>false,
            'required' => false,
            'label'=>false,
            //'choices'=>array('Choisissez un modèle'=>''),
            'query_builder' => function (EntityRepository $er) {
                return $er->createQueryBuilder('p')
                    ->orderBy('p.nomFr','ASC');
                },
            'attr' => array('class' => 'form-control input-md')
        ))
        ->add('fournisseur', EntityType::class,array(
            'class' => 'AMLASqrBundle:FournisseurMoa',
            'choice_label' => 'fournisseur.raisonSociale',
            'required' => false,
            'multiple' => true,
            'mapped'=>false,
            'label'=>false,
            'attr' => array('class' => 'form-control input-md')
        )
    )
        ->add('Montant', IntegerType::class, array('mapped'=>false,'attr'=>array('min'=>0)))
        ->add('techniques', FileType::class, array('mapped'=>false, 
            'data_class' => null,
            'label' => 'Dossier Technique(format zip)',
            'attr' => array('accept'=>'application/zip, application/x-rar-compressed'),
        ))
        ->add('financiers', FileType::class, array('mapped'=>false,
            'data_class' => null,
            'label' => 'Dossier Financier(format zip)',
            'attr' => array('accept'=>'application/zip, application/x-rar-compressed'),
        ))
        ->add('administratifs', FileType::class, array('mapped'=>false, 
            'data_class' => null,
            'label' => 'Dossier Administratif(format zip)',
            'attr' => array('accept'=>'application/zip, application/x-rar-compressed'),
        ))
        ->add('annexes', FileType::class, array('mapped'=>false,
            'data_class' => null,
            'label' => 'Annexes(format zip)',
            'attr' => array('accept'=>'application/zip, application/x-rar-compressed'),
        ))
        ->add('commentaires', TextareaType::class, array('mapped'=>false,'required' =>false));
        
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\SoummissionOffre'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_soummissionoffre';
    }


}
