<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;

class SoummissionOffreType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        //->add('fournisseur',FournissseurType::class)
        //->add('status')
        //->add('dateCreated')
        //->add('offre',OffreType::class)
        ->add('Montant', IntegerType::class, array('mapped'=>false,'attr'=>array('min'=>0)))
        ->add('techniques', FileType::class, array('mapped'=>false, 
            'data_class' => null,
            'label' => 'Dossier Technique(format zip)',
            'attr' => array('accept'=>'application/zip, application/x-rar-compressed'),
        ))
        ->add('financiers', FileType::class, array('mapped'=>false,
            'data_class' => null,
            'label' => 'Dossier Financier(format zip)',
            'attr' => array('accept'=>'application/zip, application/x-rar-compressed'),
        ))
        ->add('administratifs', FileType::class, array('mapped'=>false, 
            'data_class' => null,
            'label' => 'Dossier Administratif(format zip)',
            'attr' => array('accept'=>'application/zip, application/x-rar-compressed'),
        ))
        ->add('annexes', FileType::class, array('mapped'=>false,
            'data_class' => null,
            'label' => 'Annexes(format zip)',
            'attr' => array('accept'=>'application/zip, application/x-rar-compressed'),
        ))
        ->add('commentaires', TextareaType::class, array('mapped'=>false,'required' =>false));
        
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\SoummissionOffre'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_soummissionoffre';
    }


}
