<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;

class ServiceType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('sqrId', TextType::class, [
                'required'=>true,
                'attr'=>[
                    'placeholder'=>'XXXX-XXXX-XXXX-XXXX'
                ]
            ])
            ->add('email', EmailType::class, [
                'required'=>true,
            ])
            ->add('typePiece', ChoiceType::class, array(
                'required' => true,
                //'label' => 'Critère de diffussion',
                'multiple' => false,
                'expanded' => false,
                //'empty_data' => '0',
                'choices'  => array(
                    'Sélectionner' => '',
                    'Passport' => '0',
                    'CNI' => '1',
                    'Permis conduire' => '2',
                    'Carte de séjour' => '3',
                ),
              //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
            ))
            ->add('telephone', IntegerType::class, [
                'required'=>true,
            ])
            ->add('pieceNumber')
            ->add('dateIssued', DateType::class, array(
                //'label' => 'Date de décision',
                //'widget' => 'choice',
                'required' => true,
                'mapped'=>true,
                'widget' => 'single_text',
            ))
        ->add('placeIssued')
        //->add('fees')
        //->add('total')
        //->add('isPaid')
        //->add('dateCreated')
        //->add('transactionNumber')
        //->add('quittance')
        //->add('account');
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Service'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_service';
    }


}
