<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Doctrine\ORM\EntityRepository;


class ServiceItemType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('serviceCategory', EntityType::class, array(
                'class' => 'AMLASqrBundle:ServiceCategory',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r');
                    //->orderBy('r.nomFr', 'ASC');
                    //->Where('r.status = 0');
                },
                'choice_label' => function ($cat) {
                    return $cat->getIntitule()/*.' - '.$level->getMontant() .' FCFA - Valable '.$level->getSubscriptionLength().' Mois'*/;
                },
                //'choice_label' => 'productType',
                'required' => true,
                'mapped' => true,
                'label' => 'Catégorie service',
                'attr'   =>  array(
                    //'class'   => 'rio_drivingbundle_subscriptionhistory_level'
                ),
                'placeholder' => 'Sélectionner...',
            ))
        ->add('codification')
        ->add('intitule')
       // ->add('dateCreated')
        ->add('amount')
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\ServiceItem'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_serviceitem';
    }


}
