<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;

class SecretariatPublicType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
                ->add('objet', ChoiceType::class, array(
                'required' => true,
                'label' => 'Type de demande',
                'multiple' => false,
                'expanded' => false,
                'choices'  => array(
                    'Sélectionner' => '',
                    'Certificat de non faîte' => 'Certificat de non faîte',
                ),
                //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
            ))
                ->add('nombre', IntegerType ::class, array(
                    'label' => 'Nombre',     
                    'attr'=>array('min'=>0),
                ))
                ->add('piecejointe', FileType::class, array(
                'data_class' => null,
                'label' => 'Pièce jointe(PDF)',
                'required' => false,
            ))
                //->add('dateCreated')
                //->add('statut')
                //->add('fournisseur')
                ;
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\SecretariatPublic'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_secretariatpublic';
    }


}
