<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;

class RepertoireType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('nomRaisonSociale', TextType::class,array(
                'label'=>'Nom / Raison sociale*',
                'required' => true,
            ))
        ->add('prenomSigle', TextType::class,array(
                'label'=>'Prénom / Sigle',
                'required' => false,
            ))
        ->add('niu', TextType::class,array(
                'label'=>'NIU',
                'required' => false,
            ))
        ->add('telephone', TextType::class,array(
                'label'=>'Téléphone',
                'required' => false,
            ))
        ->add('email', EmailType::class,array(
                'label'=>'Email',
                'required' => false,
            ))
        ->add('adresse', TextType::class,array(
                'label'=>'Adresse',
                'required' => false,
            ))
        ->add('registreCommerce', TextType::class,array(
                'label'=>'Registre de commerce',
                'required' => false,
            ))
        //->add('dateCreated')->add('status')->add('fournisseur')
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Repertoire'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_repertoire';
    }


}
