<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class RemiseGracieuseType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('typeRecour', ChoiceType::class, [
            'choices'  => [
                'Sélectionner' => '',
                'ATD' => 'ATD',
                'Déclaration impot' => 'Déclaration impot',
                'DSF' => 'DSF',
            ],
            'label'=>'Type de remise'
        ])
        ->add('referenceRecour', TextType::class, [
            'label'=>'Référence de la remise'
        ])
        ->add('motif')
        ->add('justificatifRecour', FileType::class, [
            'label'=>'Justificatif de la remise'
        ])
        ->add('justificatifPaiement', FileType::class, [
            'label'=>'Preuve de paiement'
        ])
        //->add('delai')
        //->add('montant')
        //->add('statut')
        //->add('decision')
        //->add('dateCreated')
        //->add('qrCode')
        //->add('auteurDecision')
        //->add('fournisseur')
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\RemiseGracieuse'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_remisegracieuse';
    }


}
