<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
//ReceptionTravauxDemandeType
class ReceptionTravauxType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $pourcent = array();
        for( $i=1; $i<=100; $i++ )
        {
            $pourcent[$i]= $i;/*array($i=>$i);*/
        }

        $builder
        //->add('bonCommande')
        ->add('typeReception', ChoiceType::class, array(
            'required' => true,
            'label' => 'Type de reception',
            'multiple' => false,
            'expanded' => false,
            'choices'  => array(
                'Sélectionner' => '',
                'Provisoire' => 'Provisoire',
                'Partielle' => 'Partielle',
                'Définitive' => 'Définitive',
            ),
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        ->add('pourcentageReception', ChoiceType::class, array(
            'required' => true,
            'label' => 'Taux de réalisation %',
            'multiple' => false,
            'expanded' => false,
            'choices'  => array($pourcent),
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?'pourcentageReception | 
        ))
        ->add('reserve', ChoiceType::class, array(
            'required' => true,
            'label' => 'Avec des reserves ?',
            'multiple' => false,
            'expanded' => true,
            'choices'  => array(
                'Oui' => 'Avec reserves',
                'Non' => 'Sans reserves',
            ),
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?' dateCommission | memberList
        ))
        ->add('dateCommission', DateType::Class, array(
            'required' => true,
            'label' => 'Date à laquelle la commission de reception a siégé',
            'mapped'=>false,
            'widget' => 'single_text',
        ))
        ->add('memberList', TextareaType::Class, array(
            'required' => true,
            'label' => 'Liste des membres de la commission de reception',
            'mapped'=>false,
        ))
        ->add('commentaire')
        //->add('dateCreated')
        ;
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\ReceptionTravaux'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_receptiontravaux';
    }

}
