<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class QuittanceType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('reason', TextType::class, array(
            'label' => 'Objet*',
            'required' => true,
        ))
        //->add('transactionNumber')
        //->add('sender')
        ->add('receiverSocialReason', TextType::class, array(
            'label' => 'Raison Sociale',
            'required' => true,
            //'label_attr' => array('class' => 'raisonSocialeLbl'),
            //'attr'   =>  [
            //    'class'   => 'amla_sqrbundle_facturespontane_beneficiaireSocialReason'
            //],  
        ))
        ->add('receiverSqrId', TextType::class, array(
            'label' => 'SQR-ID',
            'required' => false,
            'attr'   =>  [
                'class'   => 'receiverSqrId'
            ],       
        )) 
        ->add('receiverNiu', TextType::class, array(
            'label' => 'NIU',
            'required' => true,
            'attr'   =>  [
                'class'   => 'receiverNiu'
            ],       
        ))
        ->add('receiverEmail', EmailType::class, array(
            'label' => 'Email',
            'required' => true,
        ))
        ->add('phoneNumber', IntegerType::class, array(
            'label' => 'Téléphone',
            'required' => true,
            //'label_attr' => array('class' => 'telephoneLbl'),
            //'attr'   =>  [
            //    'class'   => 'amla_sqrbundle_facturespontane_beneficiaireTelephone'
            //], 
        ))
        ->add('montant', IntegerType::class, array(
            'label' => 'Montant',
            'required' => true,
        ))
        ->add('modeReglement', ChoiceType::class, array(
            'required' => true,
            'label' => 'Mode de paiement*',
            'multiple' => false,
            'expanded' => false,
            //'empty_data' => 'TOUT',
            'choices'  => array(
                'Sélectionner' => '',
                'MTN Mobile Money' => 'MOMO',
                'Orange Money' => 'ORANGE',
                'CASH' => 'CASH',
                'Orabank' => 'ORABANK',
                'Virement Bancaire' => 'VIREMENT',
            ),
            'attr' => array(
                'class' => 'modeReglement'
            )
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        ->add('reference', TextType::class, array(
            'label' => 'Référence paiement',
            'required' => false,
            //'label_attr' => array('class' => 'referenceLbl')
        ))
        //->add('dateCreated')
        //->add('placeCreated')
        //->add('receiptNumber')
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Quittance'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_quittance';
    }


}
