<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class QuittanceFromFactureType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder        
        ->add('isSecured', ChoiceType::class, array(
            'required' => true,
            'label' => 'Type de quittance*',
            'multiple' => false,
            'expanded' => false,
            'empty_data' => '0',
            'choices'  => array(
                'Sélectionner' => '',
                'Quittance reporté' => '1',
                'Nouvelle quittance' => '0',
            ),
            'attr' => array(
                'class' => 'isSecured'
            )
        ))
        ->add('reference', TextType::class, array(
            'label' => 'Référence interne*',
            'required' => false,
            'label_attr' => array('class' => 'referenceLbl')
        ))
        ->add('montant', IntegerType ::class, array(
                'required' => true,
                'label' => 'Montant en chiffre*',     
                'attr'=>array('min'=>0),
            ))
        /*->add('montantLettre', TextType ::class, array(
                'label' => 'Montant en lettres*', 
                'required' => true,
            ))*/
        ->add('modeReglement', ChoiceType::class, array(
            'required' => true,
            'label' => 'Mode de paiement*',
            'multiple' => false,
            'expanded' => false,
            'empty_data' => 'TOUT',
            'choices'  => array(
                'Sélectionner' => '',
                'En Espèces' => 'CASH',
                'MTN Mobile Money' => 'MOMO',
                'Orange Money' => 'ORANGE',
                'Orabank' => 'ORABANK',
                'Virement Bancaire' => 'VIREMENT',
            ),
            'attr' => array(
                'class' => 'modeReglement'
            )
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        //->add('transactionNumber')
        //->add('sender')
        ->add('reference', TextType::class, array(
            'label' => 'Référence paiement',
            'required' => false,
            //'label_attr' => array('class' => 'referenceLbl')
        ))
        ->add('reason', TextareaType ::class, array(
                'label' => 'Commentaire*', 
                'required' => true,
            ))

        //->add('phoneNumber')
        //->add('dateCreated')
        //->add('placeCreated')
        //->add('receiverNiu')
        //->add('receiptNumber')
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Quittance'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_quittance';
    }


}
