<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Doctrine\ORM\EntityRepository;

class OperateurConformiteCategoryElementType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('operateurConformiteCategory', EntityType::class, array(
                'class' => 'AMLASqrBundle:OperateurConformiteCategory',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r');
                    //->orderBy('r.nomFr', 'ASC');
                    //->Where('r.status = 0');
                },
                'choice_label' => function ($level) {
                    return $level->getName()/*.' - '.$level->getMontant() .' FCFA - Valable '.$level->getSubscriptionLength().' Mois'*/;
                },
                //'choice_label' => 'productType',
                'required' => true,
                'mapped' => true,
                'label' => 'Catégorie du partenaire',
                'attr'   =>  array(
                    'class'   => 'rio_drivingbundle_subscriptionhistory_level'
                ),
                'placeholder' => 'Sélectionner...',
            ))
            ->add('name')
            ->add('sigle')
            //->add('operateurConformiteCategory')
        ;
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\OperateurConformiteCategoryElement'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_operateurconformitecategoryelement';
    }


}
