<?php

namespace AMLA\SqrBundle\Form;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Security\Core\SecurityContext;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage;

class OffreType extends AbstractType
{
    /**
     * {@inheritdoc}
     */

    protected $tokenStorage;
    protected $em;
    protected $fournisseur;

    public function __construct(TokenStorage $tokenStorage, EntityManager $entityManager)
    {
        $this->tokenStorage = $tokenStorage;
        $this->em = $entityManager;
        $user = $this->tokenStorage->getToken()->getUser();
        $this->fournisseur = $this->em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $builder
            ->add('reference', TextType::class, array(
                'label' => 'Référence ',
            ))
            ->add('objet')
            ->add('prix', IntegerType::class, array(
                'label' => 'Montant de l\'offre',
                'required' => false,
                'attr'=>array('min'=>0),
            ))
            ->add('cahierCharge', FileType::class, array('mapped'=>false,
                'data_class' => null,
                'label' => 'Cahier des charges(format zip)',
                'attr' => array('accept'=>'application/zip','application/x-rar-compressed'),
            ))
            ->add('datePublication', DateType::class, array(
                'label' => 'Date publication',
                //'widget' => 'choice',
                'widget' => 'single_text',
            ))
            ->add('dateLimite', DateType::class, array(
                'label' => 'Date de clôture',
                //'widget' => 'choice',
                'widget' => 'single_text',
            )) 
           /*  ->add('categorieB', CheckboxType::class, array(
                'mapped' => false,
                'label' => 'National ?',
                'required' => false,
            ))
            ->add('categorieC', CheckboxType::class, array(
                'mapped' => false,
                'label' => 'International?',
                'required' => false,
            ))  */
           /*  ->add('restreint', CheckboxType::class, array(
                'label' => ' ',
                'required' => false,
            ))
            ->add('Ouvert', CheckboxType::class, array(
                'mapped' => false,
                'label' => 'Ouvert',
                'required' => false,
            ))
            ->add('Gre', CheckboxType::class, array(
                'mapped' => false,
                'label' => 'Gré à gré',
                'required' => false,
            )) */
        ->add('capital', TextType::class, array(
            'label' => false,
            'attr'=>array('placeholder' =>'Rechercher par capital social minimum (valider par ESPACE)'),
            'mapped' => false,
            'required' => false,
        ))
        ->add('pays', EntityType::class,array(
            'class' => 'AMLASqrBundle:Pays',
            //'choices' => array('Rechercher par pays'=>''),
            'placeholder' => 'Rechercher par pays (Vous pouvez en choisir plusieurs)',
            'choice_label' => 'nomFr',
            'mapped'=>false,
            'required' => false,
            'label'=>false,
            'multiple' => false,
            //'choices'=>array('Choisissez un modèle'=>''),
            'query_builder' => function (EntityRepository $er) {
                return $er->createQueryBuilder('p')
                    ->orderBy('p.nomFr','ASC');
                },
            'attr' => array('class' => 'form-control input-md')
        ))
            ->add('fournisseur', EntityType::class,array(
                'class' => 'AMLASqrBundle:FournisseurMoa',
                'choice_label' => 'fournisseur.raisonSociale',
                'required' => false,
                'multiple' => true,
                'label'=>false,
                //'choices'=>array('Choisissez un modèle'=>''),
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('fm')
                        ->join('fm.fournisseur', 'f')
                        ->addSelect('f')
                        ->join('fm.moa','m')
                        ->where('m.id = :id')
                        ->setParameter('id', $this->fournisseur->getId())
                        ->orderBy('f.id','DESC');
                    },
                'attr' => array('class' => 'form-control input-md')
            )
        );

        /*$builder->addEventListener(FormEvents::PRE_SET_DATA, function (FormEvent $event) {
            $offre = $event->getData();
            $form = $event->getForm();
            if ($offre == NULL) {
                $form;
            }
        });*/

        /* $builder->get('restreint')
            ->addModelTransformer(new CallbackTransformer(
                function ($property) {
                    return (bool) $property;
                },
                function ($property) {
                    return (bool) $property;
                }
            )
        );

        $builder->get('categorieB')
            ->addModelTransformer(new CallbackTransformer(
                function ($property) {
                    return (bool) $property;
                },
                function ($property) {
                    return (bool) $property;
                }
            )
        ); */
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Offre',
            'user' => null,
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_offre';
    }


}
