<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class MoratoireDecisionType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('pourcentage')
            ->add('dureeMois')
            //->add('dateCreated')
            ->add('decision', ChoiceType::class, array(
                'required' => true,
                'label' => 'Décision',
                'multiple' => false,
                'expanded' => false,
                'empty_data' => '0',
                'choices'  => array(
                    'Sélectionner' => '',
                    'Accepter' => '1',
                    'Rejeter' => '2',
                ),
                //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
            ))
            //->add('auteurDecision')
            ->add('commentaire')
            //->add('atd')
            //->add('account')
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Moratoire'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_moratoire';
    }


}
