<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class InBillParamType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('isInbillAccess', ChoiceType::class, [
            'multiple'=>false,
            'expanded'=>false,
            'choices'  => [
                'Choisir' => '',
                'Tout le monde' => '1',
                'Mon repertoire uniquement' => '2',
                'Ma sélection' => '3',
            ],
            'label'=>'Accès In Bill',
            'attr' => array('class' => 'inBillAccess'),
        ])
        ->add('isInbillOnlyFacture', ChoiceType::class, [
            'multiple'=>false,
            'expanded'=>false,
            'choices'  => [
                'Choisir' => '',
                'IN BILL uniquement' => '1',
                'IN BILL et Autres canaux disponible' => '0',
            ],
            'label'=>'Comment souhaitez vous recevoir vos factures',
        ])
        ->add('isInbillOnlyDevis', ChoiceType::class, [
            'multiple'=>false,
            'expanded'=>false,
            'choices'  => [
                'Choisir' => '',
                'IN BILL uniquement' => '1',
                'IN BILL et Autres canaux disponible' => '0',
            ],
            'label'=>'Comment souhaitez vous recevoir vos devis',
        ])
        ->add('isInBillLanguage', ChoiceType::class, [
            'multiple'=>false,
            'expanded'=>false,
            'choices'  => [
                'Choisir' => '',
                'Français' => 'Fr',
                'Anglais' => 'En',
            ],
            'label'=>'Langue de votre IN BILL',
        ])
        //->add('dateDebut')
        //->add('dateFin')
        //->add('status')
        //->add('fournisseur')
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\InBill'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_inbill';
    }


}
