<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class FreevendingApprovisionnementType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        //->add('balance')->add('dernierDebit')->add('dernierCredit')->add('fournisseur')

        ->add('amount', IntegerType ::class, array(
            'label' => 'Montant à approvisionner*',
            'mapped'=>false,
            'attr'   =>  array(
                //'placeholder' => 'Insérer le montant de la transaction',
                'min'=>0,
                )
                //'size'=>"9",
        ))
        ->add('paymentMode', ChoiceType::class, array(
            'required' => true,
            'label' => 'Canal de paiement*',
            'multiple' => false,
            'expanded' => true,
            'mapped'=>false,
            'choices'  => array(
                'Espèce' => 'WALLET',
                'Orange Money' => 'ORANGE',
                'Mobile Money' => 'MTN',
            ),
            'attr'   =>  array(
                'class'   => 'canalPaiement'
            ),
          //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        ->add('numberToPay', IntegerType ::class, array(
            'label' => 'Numéro de facturation',
            'mapped'=>false,
            'attr'   =>  array(
                //'placeholder' => 'Insérer le montant de la transaction',
                'min'=>0,
                )
                //'size'=>"9",
        ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Freevending'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_freevending';
    }


}
