<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;

class FournissseurType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('raisonSociale')
            //->add('account',AccountType::class)
            ->add('sigle')
            ->add('niu', TextType::class, array(
                'label' => 'NIU',
            ))
            ->add('numeroRegistreCommerce', TextType::class, array(
                'label' => 'Registre de commerce',
            ))
            ->add('quartier', TextType::class, array(
                'label' => 'Quartier',
                'required' => false,
            ))
            ->add('lieuDit', TextType::class, array(
                'label' => 'Lieu dit',
                'required' => false,
            ))
            ->add('personneAContacter', TextType::class, array(
                'label' => 'Personne à contacter*',
            ))
            ->add('telephoneMobile', IntegerType::class, array(
                'label' => 'Téléphone mobile',
                'attr'=>array('min'=>0),
            ))
            ->add('telephoneFixe', IntegerType::class, array(
                'label' => 'Téléphone fixe',
                'attr'=>array('min'=>0),
                'required' => false,
            ))
            ->add('adresseEmail', EmailType::class, array(
                'label' => 'Adresse email',
            ))
            ->add('siteWeb', TextType::class, array(
                'label' => 'Site web',
                'required' => false,
            ))
            ->add('boitePostale', TextType::class, array(
                'label' => 'Boîte postale',
                'required' => false,
            ))
            ->add('ville', TextType::class, array(
                'label' => 'Ville',
                'required' => false,
            ))
            ->add('activite',EntityType::class, array(
                'class' => 'AMLASqrBundle:Activite',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('a')
                        ->orderBy('a.libelle', 'ASC');
                },
                'choice_label' => function ($commune) {
                    return $commune->getLibelle();
                },
                //'choice_label' => 'libelleRegion',
                'required' => true,
                'mapped' => true,
                'label' => 'Activités*',
                'placeholder' => 'Sélectionner...',
            ))
            ->add('formeJuridique', EntityType::class, array(
                'class' => 'AMLASqrBundle:statutJuridique',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r')
                        ->orderBy('r.intitule', 'ASC');
                },
                'choice_label' => function ($statutjuridique) {
                    return $statutjuridique->getIntitule();
                },
                //'choice_label' => 'libelleRegion',
                'required' => true,
                'mapped' => true,
                'label' => 'Statut Juridique *',
                'placeholder' => 'Sélectionner...',
            ))
            ->add('regimeFiscal', EntityType::class, array(
                'class' => 'AMLASqrBundle:RegimeFiscal',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r')
                        ->orderBy('r.intitule', 'ASC');
                },
                'choice_label' => function ($regimefiscal) {
                    return $regimefiscal->getIntitule();
                },
                //'choice_label' => 'libelleRegion',
                'required' => true,
                'mapped' => true,
                'label' => 'Régime fiscal*',
                'placeholder' => 'Sélectionner...',
            ))
            ->add('centrerattachement', EntityType::class, array(
                'class' => 'AMLASqrBundle:CentreRattachement',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r')
                        ->orderBy('r.intitule', 'ASC');
                },
                'choice_label' => function ($centrederattachement) {
                    return $centrederattachement->getIntitule();
                },
                //'choice_label' => 'libelleRegion',
                'required' => true,
                'mapped' => true,
                'label' => 'Centre des impôts*',
                'placeholder' => 'Sélectionner...',
            ))
            ->add('commune',EntityType::class, array(
                'class' => 'AMLASqrBundle:Commune',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r')
                        ->orderBy('r.libelle', 'ASC');
                },
                'choice_label' => function ($commune) {
                    return $commune->getLibelle();
                },
                //'choice_label' => 'libelleRegion',
                'required' => true,
                'mapped' => true,
                'label' => 'Communes*',
                'placeholder' => 'Sélectionner...',
            ))
            ->add('logo', FileType::class, array(
                'data_class' => null,
                'label' => 'Logo (image)',
                'required' => true,
            ))
            /*->add('account', AccountType::class, array(
                'label' => 'Paramètres de connexion*',
            ))*/
           // ->add('dateCreated')
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Fournissseur'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_fournissseur';
    }


}
