<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;

class FournisseurHabiliteType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('raisonSociale', TextType::class, array(
            'label' => 'Raison sociale*',
        ))
        ->add('sigle', TextType::class, array(
            'label' => 'Sigle',
            'required'=>false,
        ))
        ->add('niu', TextType::class, array(
            'label' => 'NIU*',
        ))
        ->add('activitePrincipale', TextType::class, array(
            'label' => 'Activité principale*',
        ))
        ->add('regime', TextType::class, array(
            'label' => 'Régime*',
        ))
        ->add('boitePostale', TextType::class, array(
            'label' => 'Boite postale',
            'required'=>false,
        ))
        ->add('telephone', TextType::class, array(
            'label' => 'Téléphone*',
        ))
        ->add('email', EmailType::class, array(
            'label' => 'Email*',
        ))
        ->add('formeJuridique', TextType::class, array(
            'label' => 'Forme juridique*',
        ))
        ->add('cri', TextType::class, array(
            'label' => 'Centre régional des impots*',
        ))
        ->add('centreDeRattachement', TextType::class, array(
            'label' => 'Centre de rattachement*',
        ))
        ->add('regionAdministration', TextType::class, array(
            'label' => 'Région Administrative*',
        ))
        ->add('departement', TextType::class, array(
            'label' => 'Département*',
        ))
        ->add('ville', TextType::class, array(
            'label' => 'Ville*',
        ))
        ->add('commune', TextType::class, array(
            'label' => 'Commune*',
        ))
        ->add('quartier', TextType::class, array(
            'label' => 'Quartier*',
        ))
        ->add('lieuxDit', TextType::class, array(
            'label' => 'Lieu dit*',
        ))
        //->add('etatNiu')
        //->add('dateCreated')
        //->add('status')
        //->add('qrCode')
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\FournisseurHabilite'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_fournisseurhabilite';
    }


}
