<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class FournisseurBanqueAccessType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('niu', TextType::class,array(
                'label'=>'NIU',
                'mapped'=>false,
                'required'=>false,
            ))
            ->add('raisonSociale', TextType::class,array(
                'label'=>'Raison sociale',
                'mapped'=>false,
                'required'=>false,
            ))
            /*->add('statut')
            ->add('dateCreated')
            ->add('fournisseur')
            ->add('banque')*/
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\FournisseurBanqueAccess'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_fournisseurbanqueaccess';
    }


}
