<?php

namespace AMLA\SqrBundle\Form; 

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;

class FineType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            //->add('dateCreated')
            ->add('sqrId', TextType::class, [
                'required'=>true,
                'attr'=>[
                    'placeholder'=>'XXXX-XXXX-XXXX-XXXX'
                ]
            ])
            ->add('email', EmailType::class, [
                'required'=>true,
            ])
            ->add('typePiece', ChoiceType::class, array(
                'required' => true,
                //'label' => 'Critère de diffussion',
                'multiple' => false,
                'expanded' => false,
                //'empty_data' => '0',
                'choices'  => array(
                    'Sélectionner' => '',
                    'Passport' => '0',
                    'CNI' => '1',
                    'Permis conduire' => '2',
                    'Carte de séjour' => '3',
                ),
              //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
            ))
            ->add('telephone', IntegerType::class, [
                'required'=>true,
            ])
            ->add('pieceNumber')
            ->add('dateIssuedPiece', DateType::class, array(
                //'label' => 'Date de décision',
                //'widget' => 'choice',
                'required' => true,
                'mapped'=>true,
                'widget' => 'single_text',
            ))
            ->add('placeIssuedPiece')
            //->add('frais')
            //->add('total')
            //->add('matriculeVerbaliseur')
            //->add('status')
            //->add('isPaid')
            //->add('transactionNumber')
            ->add('fineItemMotif1', EntityType::class, array(
                'class' => 'AMLASqrBundle:FineItem',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r');
                    //->orderBy('r.nomFr', 'ASC');
                    //->Where('r.status = 0');
                },
                'choice_label' => function ($fine) {
                    return $fine->getIntitule()/*.' - '.$level->getMontant() .' FCFA - Valable '.$level->getSubscriptionLength().' Mois'*/;
                },
                //'choice_label' => 'productType',
                'required' => true,
                'mapped' => true,
                'label' => 'Motif amende 1',
                'attr'   =>  array(
                    //'class'   => 'rio_drivingbundle_subscriptionhistory_level'
                ),
                'placeholder' => 'Sélectionner...',
            ))
            ->add('localite1')
            ->add('fineItemMotif2', EntityType::class, array(
                'class' => 'AMLASqrBundle:FineItem',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r');
                    //->orderBy('r.nomFr', 'ASC');
                    //->Where('r.status = 0');
                },
                'choice_label' => function ($fine) {
                    return $fine->getIntitule()/*.' - '.$level->getMontant() .' FCFA - Valable '.$level->getSubscriptionLength().' Mois'*/;
                },
                //'choice_label' => 'productType',
                'required' => false,
                'mapped' => true,
                'label' => 'Motif amende 2',
                'attr'   =>  array(
                    //'class'   => 'rio_drivingbundle_subscriptionhistory_level'
                ),
                'placeholder' => 'Sélectionner...',
            ))
            ->add('localite2', TextType::class, [
                'required'=>false,
            ])
            ->add('fineItemMotif3', EntityType::class, array(
                'class' => 'AMLASqrBundle:FineItem',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r');
                    //->orderBy('r.nomFr', 'ASC');
                    //->Where('r.status = 0');
                },
                'choice_label' => function ($fine) {
                    return $fine->getIntitule()/*.' - '.$level->getMontant() .' FCFA - Valable '.$level->getSubscriptionLength().' Mois'*/;
                },
                //'choice_label' => 'productType',
                'required' => false,
                'mapped' => true,
                'label' => 'Motif amende 3',
                'attr'   =>  array(
                    //'class'   => 'rio_drivingbundle_subscriptionhistory_level'
                ),
                'placeholder' => 'Sélectionner...',
            ))
            ->add('localite3', TextType::class, [
                'required'=>false,
            ]);
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Fine'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_fine';
    }


}
