<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class FactureSpontaneType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('isSecured'/*, TextType::class, array(
            'label' => 'ATTN*',
            'required' => true,
        )*/)
        ->add('attn', TextType::class, array(
            'label' => 'ATTN*',
            'required' => true,
        ))
        ->add('objet', TextType::class, array(
            'label' => 'Objet*',
            'required' => true,
        ))
        ->add('reference', TextType::class, array(
            'label' => 'Référence',
            'required' => false,
        ))
        ->add('beneficiaireNiu', TextType::class, array(
            'label' => 'NIU du destinataire*',
            'required' => false,
            'attr'   =>  [
                'class'   => 'amla_sqrbundle_facturespontane_beneficiaireNiu'
            ],            
            //
        ))
        ->add('beneficiaireSocialReason', TextType::class, array(
            'label' => 'Raison Sociale du destinataire*',
            'required' => true,
            'attr'   =>  [
                'class'   => 'amla_sqrbundle_facturespontane_beneficiaireSocialReason'
            ],  
        ))
        ->add('beneficiaireEmail', EmailType::class, array(
            'label' => 'Email bénéficiaire*',
            'required' => true,
            'attr'   =>  [
                'class'   => 'amla_sqrbundle_facturespontane_beneficiaireEmail'
            ],  
        ))
        ->add('beneficiaireTelephone', IntegerType::class, array(
            'label' => 'Téléphone bénéficiaire*',
            'required' => true,
            'attr'   =>  [
                'class'   => 'amla_sqrbundle_facturespontane_beneficiaireTelephone'
            ], 
        ))
        /*->add('emetteurTelephone', IntegerType::class, array(
            'label' => 'Téléphone émetteur*',
            'required' => true,
        ))
        ->add('modeReglement', ChoiceType::class, array(
            'required' => true,
            'label' => 'Mode de paiement',
            'multiple' => false,
            'expanded' => true,
            'empty_data' => 'TOUT',
            'choices'  => array(
                //'Aucune précision' => 'TOUT',
                'MTN Mobile Money' => 'MOMO',
                'Orange Money' => 'ORANGE',
                'Orabank' => 'ORABANK',
                'Virement Bancaire' => 'VIREMENT',
            ),
            'attr' => array(
                'class' => 'modeReglement'
            )
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))*/
        //->add('montantTotalHt')
        //->add('montantTotalTtc')
        //->add('statut')
        //->add('dateCreated')
        //->add('account')
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\FactureSpontane'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_facturespontane';
    }

}
