<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;

class FactureSimpleSecuriseType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('amount', IntegerType::class, array(
            'label' => 'Montant*',
            'required' => true,
        ))
        ->add('niu', TextType::class, array(
            'label' => 'NIU',
            'required' => false,
        ))
        ->add('niuName', TextType::class, array(
            'label' => 'Nom / Raison Sociale',
            'required' => false,
            'mapped' => true,
            'attr' => array(
                'readonly' => true
            )
        ))
        ->add('canal', ChoiceType::class, array(
            'required' => true,
            'label' => 'Canal*',
            'multiple' => false,
            'expanded' => false,
            'mapped'=>true,
            'empty_data' => 'TOUT',
            'choices'  => array(
                'Sélectionner' => '',
                'MTN Mobile Money' => 'MOMO',
                'Orange Money' => 'ORANGE',
                'Orabank' => 'ORABANK',
                'YUP' => 'YUP',
            ),
            'attr' => array(
                'class' => 'modeReglement'
            )
        ))
        ->add('number', TextType::class, array(
            'label' => 'Numéro/Identifiant(format international)*',
            'required' => true,
            'attr'=>[
                'placeholder'=>'Exemple : 237675624218',
                'autocomplete'=>'off',
            ]
            //'value' => '237',
        ))
        /*->add('status')
        ->add('dateCreated')
        ->add('account')
        ->add('qrCode')*/
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\FactureSimple'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_facturesimple';
    }

}
