<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class FactureSecuriseInBillType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder 
        ->add('categorie', ChoiceType::class, array(
            'required' => true,
            'mapped' => false,
            'label' => 'Categorie du bénéficiaire',
            'multiple' => false,
            'expanded' => false,
            'choices'  => array(
                'Sélectionner' => '',
                'Administration publique ou assimilé' => 'PUBLIC',
                'Autre' => 'PRIVE',
            ),
            'attr' => array(
                'class' => 'factureCategorie'
            )
        ))
        ->add('factureElements', ChoiceType::class, array(
            'required' => true,
            'mapped' => false,
            'label' => 'Elements à facturer',
            'multiple' => false,
            'expanded' => false,
            'choices'  => array(
                'Sélectionner' => '',
                'Produits' => '1',
                'Services' => '2',
                'Produits et services' => '3',
            ),
            'attr' => array(
                'class' => 'factureElements'
            )
        ))/*
        ->add('isSecured', ChoiceType::class, array(
            'required' => true,
            'label' => 'Type de facturation',
            'multiple' => false,
            'expanded' => false,
            'empty_data' => '0',
            'choices'  => array(
                'Sélectionner' => '',
                'Facture reporté' => '1',
                'Nouvelle facture' => '0',
            ),
            'attr' => array(
                'class' => 'isSecured'
            )
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        ->add('reference', TextType::class, array(
            'label' => 'Référence facture papier*',
            'required' => false,
            'label_attr' => array('class' => 'referenceLbl')
        ))
        ->add('beneficiaireNiu', TextType::class, array(
            'label' => 'NIU du bénéficiaire*',
            'required' => false,
            'attr'   =>  [
                'class'   => 'amla_sqrbundle_facturespontane_beneficiaireNiu'
            ],       
        ))
        ->add('attn', TextType::class, array(
            'label' => 'ATTN*',
            'required' => true,
        ))
        ->add('beneficiaireSocialReason', TextType::class, array(
            'label' => 'Raison Sociale*',
            'required' => true,
            'label_attr' => array('class' => 'raisonSocialeLbl'),
            'attr'   =>  [
                'class'   => 'amla_sqrbundle_facturespontane_beneficiaireSocialReason'
            ],  
        ))
        ->add('beneficiaireEmail', EmailType::class, array(
            'label' => 'Email*',
            'required' => true,
            'label_attr' => array('class' => 'emailLbl'),
            'attr'   =>  [
                'class'   => 'amla_sqrbundle_facturespontane_beneficiaireEmail'
            ],  
        ))
        ->add('beneficiaireTelephone', IntegerType::class, array(
            'label' => 'Téléphone*',
            'required' => true,
            'label_attr' => array('class' => 'telephoneLbl'),
            'attr'   =>  [
                'class'   => 'amla_sqrbundle_facturespontane_beneficiaireTelephone'
            ], 
        ))*/
        ->add('objet', TextType::class, array(
            'label' => 'Objet*',
            'required' => true,
        ))
        /*->add('modeReglement', ChoiceType::class, array(
            'required' => true,
            'label' => 'Mode de paiement*',
            'multiple' => false,
            'expanded' => false,
            'empty_data' => 'TOUT',
            'choices'  => array(
                'Sélectionner' => '',
                'Aucune précision' => 'TOUT',
                'MTN Mobile Money' => 'MOMO',
                'Orange Money' => 'ORANGE',
                'Orabank' => 'ORABANK',
                'Virement Bancaire' => 'VIREMENT',
            ),
            'attr' => array(
                'class' => 'modeReglement'
            )
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        ->add('emetteurTelephone', IntegerType::class, array(
            'label' => 'Téléphone émetteur*',
            'required' => true,
        ))*/
        //->add('montantTotalHt')
        //->add('montantTotalTtc')
        //->add('statut')
        //->add('dateCreated')
        //->add('account')
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\FactureSpontane'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_facturespontane';
    }

}
