<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class ExchangeType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('numberToSend', IntegerType ::class, array(
            'label' => 'Numéro a créditer*',
            'attr'   =>  array(
                //'placeholder' => 'Insérer le numéro a créditer',
                'min'=>0,
                )
                //'size'=>"9",
        ))
        ->add('amount', IntegerType ::class, array(
            'label' => 'Montant à transférer*',
            'attr'   =>  array(
                //'placeholder' => 'Insérer le montant de la transaction',
                'min'=>0,
                )
                //'size'=>"9",
        ))
        ->add('operator', ChoiceType::class, array(
            'required' => true,
            'label' => 'Opérateur*',
            'multiple' => false,
            'expanded' => false,
            'choices'  => array(
                'Sélectionner' => '',
                'NEXTTEL' => 'NEXTTEL',
                'ORANGE' => 'ORANGE',
                'MTN' => 'MTN',
                'CAMTEL' => 'CAMTEL',
            ),
            'attr'   =>  array(
                'class'   => 'opérateur'
            ),
          //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        //->add('operation')
        ->add('paymentMode', ChoiceType::class, array(
            'required' => true,
            'label' => 'Canal de paiement*',
            'multiple' => false,
            'expanded' => true,
            'choices'  => array(
                'Compte Freevending' => 'WALLET',
                'Orange Money' => 'ORANGE',
                'Mobile Money' => 'MTN',
            ),
            'attr'   =>  array(
                'class'   => 'canalPaiement'
            ),
          //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        ->add('numberToPay', IntegerType ::class, array(
            'label' => 'Numéro de paiement',
            'attr'   =>  array(
                //'placeholder' => 'Insérer le montant de la transaction',
                'min'=>0,
                )
                //'size'=>"9",
        ))
        //->add('dateCreated')
        //->add('status')
        //->add('comment')
        //->add('fournisseur')
        //->add('account')
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Exchange'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_exchange';
    }


}
