<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;

class EnregistrementPmType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('isEntreprise', HiddenType::class, array(
            'data' => '1',
        ))
        ->add('raisonSociale', TextType::class, array(
            'label' => 'Raison sociale*',
        ))
        ->add('sigle', TextType::class, array(
            'label' => 'Sigle',
            'required'=>false,
        ))
        ->add('dateCreation', DateType::class, array(
            'label' => 'Date de création*',
            //'required' => false,
            'widget' => 'single_text',
        ))
        ->add('lieuCreation', TextType::class, array(
            'label' => 'Lieu de création*',
        ))
        ->add('nomDirigeant', TextType::class, array(
            'label' => 'Nom du dirigeant*',
            'required'=>false,
        ))
        ->add('formeJuridique', ChoiceType::class, array(
            'required' => true,
            'label' => 'Forme juridique*',
            'multiple' => false,
            'expanded' => false,
            'choices'  => array(
                'Sélectionner' => '',
                'Association' => 'Association',
                'Entreprise individuelle' => 'Entreprise individuelle',
                'Filiale' => 'Filiale',
                'Organisation internationale' => 'Organisation internationale',
                'Organisation non gouvernementale' => 'Organisation non gouvernementale',
                'Société à responsabilités limités' => 'Société à responsabilités limités',
                'Société anonyme' => 'Société anonyme',
                'Succursale de société étrangère' => 'Succursale de société étrangère',
            ),
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        ->add('regime', ChoiceType::class, array(
            'required' => true,
            'label' => 'Régime fiscal*',
            'multiple' => false,
            'expanded' => false,
            'choices'  => array(
                'Sélectionner' => '',
                'Hors régime d\'imposition' => 'Hors régime d\'imposition',
                'Libératoire' => 'Libératoire',
                'Salarié' => 'Salarié',
                'Simplifié' => 'Simplifié',
            ),
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        //->add('niu')
        ->add('activiteDeclaree', TextType::class, array(
            'label' => 'Activité déclarée*',
        ))
        ->add('pays', TextType::class, array(
            'label' => 'Pays*',
            'required'=>true,
        ))
        ->add('regionAdministration', TextType::class, array(
            'label' => 'Région*',
            'required'=>true,
        ))
        ->add('departement', TextType::class, array(
            'label' => 'Département*',
            'required'=>true,
        ))
        ->add('ville', TextType::class, array(
            'label' => 'Ville*',
            'required'=>true,
        ))
        ->add('commune', TextType::class, array(
            'label' => 'Commune*',
            'required'=>true,
        ))
        ->add('quartier', TextType::class, array(
            'label' => 'Quartier*',
            'required'=>true,
        ))
        ->add('lieuDit', TextType::class, array(
            'label' => 'Lieu dit*',
            'required'=>true,
        ))
        ->add('boitePostale', TextType::class, array(
            'label' => 'Boite postale',
            'required'=>true,
        ))
        ->add('telephone', TextType::class, array(
            'label' => 'Téléphone*',
            'required'=>true,
        ))
        ->add('email', EmailType::class, array(
            'label' => 'Email*',
            'required'=>true,
        ))
        ->add('observation', TextareaType::class, array(
            'label' => 'Observation',
            'required'=>false,
        ))
        ->add('typePiece', ChoiceType::class, array(
            'required' => true,
            'label' => 'Type de pièce d\'identité*',
            'multiple' => false,
            'expanded' => false,
            'choices'  => array(
                'Sélectionner' => '',
                'CNI' => 'CNI',
                'Passport' => 'Passport',
                'Carte de sejour' => 'Carte de sejour',
                'Autre' => 'Autre',
            ),
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        ->add('numeroPiece', IntegerType::class, array(
            'label' => 'Numéro pièce identité*',
            'required'=>true,
        ))
        ->add('imagePiece1', FileType::class, array(
            'label' => 'Photo pièce identité recto*',
            'required'=>false,
        ))
        ->add('imagePiece2', FileType::class, array(
            'label' => 'Photo pièce identité verso*',
            'required'=>false,
        ))
       /* ->add('departement', TextType::class, array(
            'label' => 'Département*',
        ))
        ->add('ville', TextType::class, array(
            'label' => 'Ville*',
        ))
        ->add('etatNiu')
        ->add('dateCreated')
        ->add('status')*/
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\EnregistrementPm'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_enregistrementpm';
    }


}
