<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;

class EnregistrementPmPhysiqueType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('isEntreprise', HiddenType::class, array(
            'data' => '0',
        ))
        ->add('nom', TextType::class, array(
            'label' => 'Nom*',
            'required'=>true,
        ))
        ->add('prenom', TextType::class, array(
            'label' => 'Prénom',
            'required'=>false,
        ))
        ->add('dateNaissance', DateType::class, array(
            'label' => 'Date de naissance*',
            'required'=>true,
            'widget' => 'single_text',
        ))
        ->add('lieuNaissance', TextType::class, array(
            'label' => 'Lieu de naissance*',
            'required'=>true,
        ))
        ->add('nomMere', TextType::class, array(
            'label' => 'Nom de la mère*',
            'required'=>true,
        ))
        ->add('prenomMere', TextType::class, array(
            'label' => 'Prénom de la mère',
            'required'=>false,
        ))
        ->add('nomPere', TextType::class, array(
            'label' => 'Nom du père*',
            'required'=>true,
        ))
        //->add('niu')
        ->add('prenomPere', TextType::class, array(
            'label' => 'Prénom du père',
            'required'=>false,
        ))
        ->add('sexe', ChoiceType::class, array(
            'required' => true,
            'label' => 'Sexe*',
            'multiple' => false,
            'expanded' => true,
            'choices'  => array(
                'Masculin' => 'Masculin',
                'Féminin' => 'Féminin',
            ),
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        ->add('situationMatrimoniale', ChoiceType::class, array(
            'label' => 'Etat civil*',
            'required'=>true,
            'multiple' => false,
            'expanded' => false,
            'choices'  => array(
                'Choisir' => '',
                'Célibataire' => 'Célibataire',
                'Divorcé(e)' => 'Divorcé(e)',
                'Marié(e)' => 'Marié(e)',
                'Veuf(ve)' => 'Veuf(ve)',
            ),
        ))
        ->add('regime', ChoiceType::class, array(
            'required' => true,
            'label' => 'Régime fiscal*',
            'multiple' => false,
            'expanded' => false,
            'choices'  => array(
                'Sélectionner' => '',
                'Hors régime d\'imposition' => 'Hors régime d\'imposition',
                'Libératoire' => 'Libératoire',
                'Salarié' => 'Salarié',
                'Simplifié' => 'Simplifié',
            ),
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        //->add('niu')
        ->add('activiteDeclaree', TextType::class, array(
            'label' => 'Activité déclarée*',
            'required'=>true,
        ))
        ->add('pays', TextType::class, array(
            'label' => 'Pays*',
            'required'=>true,
        ))
        ->add('regionAdministration', TextType::class, array(
            'label' => 'Région*',
            'required'=>true,
        ))
        ->add('departement', TextType::class, array(
            'label' => 'Département*',
            'required'=>true,
        ))
        ->add('ville', TextType::class, array(
            'label' => 'Ville*',
            'required'=>true,
        ))
        ->add('commune', TextType::class, array(
            'label' => 'Commune*',
            'required'=>true,
        ))
        ->add('quartier', TextType::class, array(
            'label' => 'Quartier*',
            'required'=>true,
        ))
        ->add('lieuDit', TextType::class, array(
            'label' => 'Lieu dit*',
            'required'=>true,
        ))
        ->add('boitePostale', TextType::class, array(
            'label' => 'Boite postale',
            'required'=>true,
        ))
        ->add('telephone', TextType::class, array(
            'label' => 'Téléphone*',
            'required'=>true,
        ))
        ->add('email', EmailType::class, array(
            'label' => 'Email*',
            'required'=>true,
        ))
        ->add('observation', TextareaType::class, array(
            'label' => 'Observation',
            'required'=>false,
        ))
        ->add('typePiece', ChoiceType::class, array(
            'required' => true,
            'label' => 'Type de pièce d\'identité*',
            'multiple' => false,
            'expanded' => false,
            'choices'  => array(
                'Sélectionner' => '',
                'CNI' => 'CNI',
                'Passport' => 'Passport',
                'Carte de sejour' => 'Carte de sejour',
                'Autre' => 'Autre',
            ),
            //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        ->add('numeroPiece', IntegerType::class, array(
            'label' => 'Numéro pièce identité*',
            'required'=>true,
        ))
        ->add('imagePiece1', FileType::class, array(
            'label' => 'Photo pièce identité recto*',
            'required'=>false,
        ))
        ->add('imagePiece2', FileType::class, array(
            'label' => 'Photo pièce identité verso*',
            'required'=>false,
        ))
       /* ->add('departement', TextType::class, array(
            'label' => 'Département*',
        ))
        ->add('ville', TextType::class, array(
            'label' => 'Ville*',
        ))
        ->add('etatNiu')
        ->add('dateCreated')
        ->add('status')*/
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\EnregistrementPm'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_enregistrementpm';
    }


}
