<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Doctrine\ORM\EntityRepository;

class ContratType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('termeDetail', TextareaType::class, array(
            'label'=>'Version électronique du contrat',
        ))
        ->add('termeDetailScan', FileType::class, array(
            'label'=>'Scan du contrat',
        ))
        /*->add('niuPrestataire')
        ->add('niuCommanditaire')
        ->add('nomPrestataire')
        ->add('nomCommanditaire')
        ->add('sigleStructurePrestataire')
        ->add('sigleStructureCommanditaire')
        ->add('nomSignaturePrestataire')
        ->add('nomSignatureCommanditaire')*/
        ->add('dureeContrat')
        //->add('offre')
        ->add('montantHtLocal')
        ->add('montantHtExterieur')
        ->add('etablissement')
        ->add('droitFixe')
        ->add('resident')
       // ->add('moyenPaiement')
        ->add('banquePaiement')
        ->add('ribPaiement')
        ->add('niu')
        ->add('numeroMarche')
        //->add('maitreOuvrage')
        ->add('idMaitreOuvrage', EntityType::class, array(
                'class' => 'AMLASqrBundle:MaitreOuvrage',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r')
                        ->orderBy('r.libelle', 'ASC');
                },
                'choice_label' => function ($idMaitreOuvrage) {
                    return $idMaitreOuvrage->getLibelle();
                },
                //'choice_label' => 'libelleRegion',
                'required' => true,
                'mapped' => true,
                'label' => 'Maitre d\'ouvrage',
                'placeholder' => 'Choisir le maitre d\'ouvrage...',
                //'attr' => array('class' => 'mcountryclass'),
            ))
        ->add('idCelluleEnregistrement', EntityType::class, array(
                'class' => 'AMLASqrBundle:CelluleEnregistrement',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r')
                        ->orderBy('r.libelle', 'ASC');
                },
                'choice_label' => function ($idCelluleEnregistrement) {
                    return $idCelluleEnregistrement->getLibelle();
                },
                //'choice_label' => 'libelleRegion',
                'required' => true,
                'mapped' => true,
                'label' => 'Cellule d\'enregistrement',
                'placeholder' => 'Choisir la cellule d\'enregistrement...',
                //'attr' => array('class' => 'mcountryclass'),
            ))
        ->add('idOrganismeFinancement', EntityType::class, array(
                'class' => 'AMLASqrBundle:OrganismeFinancement',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r')
                        ->orderBy('r.libelle', 'ASC');
                },
                'choice_label' => function ($idOrganismeFinancement) {
                    return $idOrganismeFinancement->getLibelle();
                },
                //'choice_label' => 'libelleRegion',
                'required' => true,
                'mapped' => true,
                'label' => 'Organisme de financement',
                'placeholder' => 'Choisir l\'organisme de financement...',
                //'attr' => array('class' => 'mcountryclass'),
            ))
        ->add('dateSignature', DateType::class, array(
                'label' => 'Date de signature',
                //'widget' => 'choice',
                'required' => true,
                'widget' => 'single_text',
            ))
        ->add('dateVisa', DateType::class, array(
                'label' => 'Date de visa',
                //'widget' => 'choice',
                'required' => true,
                'widget' => 'single_text',
            ))
        ->add('nombreExemplaire')
        ->add('nombrePageExemplaire')
        ->add('nombreAnnexe')
        ->add('pourcentGarantie')
        ->add('pourcentCautionnement')
        ->add('pourcentNantissement')
        ->add('cautionSurTtc')
        ->add('garantieSurTtc')
        ->add('nantissementSurTtc')
        ->add('dossierTimbre')
        ->add('carburant')
        ->add('tvaIgnoree')
        ->add('enregistrementGratis')
        /*->add('idshareApplication')
        ->add('dateCreated')->add('status')
        ->add('dateEmissionDgi')
        ->add('dateGenerated')
        ->add('dateLimitePaiement')
        ->add('montant')
        ->add('numeroDeclaration')
        ->add('penalite')
        ->add('penaliteFuture')
        ->add('principal')
        ->add('referenceImpot')
        ->add('referenceChecktatoo')
        ->add('typeMarche')
        ->add('result')
        ->add('account')*/
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Contrat'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_contrat';
    }


}
