<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;

class ConformiteBcpmeType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('email', EmailType::class, [
                'required' => true,
                'label'=>'Email',
                'attr'   =>  array(
                    'placeholder'   => 'Insérer votre adresse email'
                ),
                'label_attr' => array('id' => 'amla_sqrbundle_conformite_email_lbl')
            ])

            ->add('niuStatus', ChoiceType::class, [
                'required' => true,
                'multiple'=>false,
                'expanded'=>true,
                'choices'  => [
                    'OUI' => 'OUI',
                    'NON' => 'NON',
                ],
                'label'=>'Avez vous un NIU ?',
                'attr'   =>  array(
                    'class'   => 'niuStatus'
                ),
                'label_attr' => array('id' => 'amla_sqrbundle_conformite_niuStatus_lbl')
            ])
            /*->add('numeroClient', TextType::class, [
                'required' => false,
                'label'=>' ',
                'attr'   =>  array(
                    'placeholder'   => 'Insérer votre numéro client'
                ),
            ])
            ->add('numeroCompte', TextType::class, [
                'required' => false,
                'label'=>' ',
                'attr'   =>  array(
                    'placeholder'   => 'Insérer votre numéro de compte'
                ),
            ])
            ->add('agence', TextType::class, [
                'required' => false,
                'label'=>' ',
                'attr'   =>  array(
                    'placeholder'   => 'Insérer le nom de votre agence'
                ),
            ])
            ->add('numeroCompteur', TextType::class, [
                'required' => false,
                'label'=>' ',
                'attr'   =>  array(
                    'placeholder'   => 'Insérer votre numéro compteur'
                ),
            ])
            ->add('numeroContrat', TextType::class, [
                'required' => false,
                'label'=>' ',
                'attr'   =>  array(
                    'placeholder'   => 'Insérer votre numéro contrat'
                ),
            ])
            ->add('numeroFacture', TextType::class, [
                'label'=>' ',
                'required' => false,
                'attr'   =>  array(
                    'placeholder'   => 'Insérer votre numéro facture'
                ),
            ])*/
            ->add('niu', TextType::class, [
                'required' => true,
                'label'=>'NIU',
                'attr'   =>  array(
                    'placeholder'   => 'Insérer votre NIU',
                    'class'   => 'niu'
                ),
                'label_attr' => array('id' => 'amla_sqrbundle_conformite_niu_lbl')
            ])
            ->add('niuName', TextType::class, [
                'required' => false,
                'label'=>'Nom/Raison sociale du contribuable',
                'attr'   =>  array(
                    'placeholder'   => ' ',
                    //'disabled'   => 'true'
                    'readonly' =>'true'
                ),
                'label_attr' => array('id' => 'amla_sqrbundle_conformite_niuName_lbl')
            ])
            ->add('operateurConformiteCategory', HiddenType::class, [
                'data' => '1',
            ])
            ->add('operateurConformiteCategoryElement', HiddenType::class, [
                'data' => '3',
            ])
            /*->add('operateurConformiteCategory', EntityType::class, array(
                'class' => 'AMLASqrBundle:OperateurConformiteCategory',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r')
                        ->orderBy('r.name', 'ASC');
                    //->Where('r.status = 0');
                },
                'choice_label' => function ($level) {
                    return $level->getName();
                },
                //'choice_label' => 'productType',
                'required' => false,
                'mapped' => true,
                'label' => 'Secteur d\'activité',
                'attr'   =>  array(
                    'class'   => 'operateurConformiteCategory'
                ),
                'placeholder' => 'Sélectionner...',
            ))
             ->add('operateurConformiteCategoryElement', ChoiceType::class, [
                 'required' => false,
                 'multiple'=>false,
                 'expanded'=>false,
                 'mapped'=>false,
                 'choices'  => [
                     'Sélectionner' => '',
                 ],
                 'attr'   =>  array(
                     'class'   => 'Partenaire'
                 ),
                 'label'=>'Sélectionner',
             ])
            ->add('operateur', ChoiceType::class, [
                  'required' => true,
                  'required'=>'true',
                  'multiple'=>false,
                  'expanded'=>false,
                  'choices'  => [
                      'Sélectionner un opérateur' => '',
                      'ENEO' => 'ENEO',
                      'CDE' => 'CDE',
                      'CAMTEL' => 'CAMTEL',
                      'ORANGE' => 'ORANGE',
                      'MTN' => 'MTN',
                      'CANAL+' => 'CANAL+',
                  ],
                  'attr'   =>  array(
                      'class'   => 'operateur'
                  ),
                  'label'=>'Opérateur',
              ])*/

            ->add('value1', TextType::class, [
                'required' => true,
                'label'=>' ',
                'attr'   =>  array(
                    'placeholder'   => ' '
                ),
                'label_attr' => array('id' => 'amla_sqrbundle_conformite_value1_lbl')
            ])
            ->add('value2', TextType::class, [
                'required' => false,
                'label'=>' ',
                'attr'   =>  array(
                    'placeholder'   => ' '
                ),
                'label_attr' => array('id' => 'amla_sqrbundle_conformite_value2_lbl')
            ])
            ->add('value3', TextType::class, [
                'required' => false,
                'label'=>' ',
                'attr'   =>  array(
                    'placeholder'   => ' '
                ),
                'label_attr' => array('id' => 'amla_sqrbundle_conformite_value3_lbl')
            ])
            ->add('nomRaisonSocialeClient', TextType::class, [
                'required' => false,
                'label'=>' ',
                'attr'   =>  array(
                    'placeholder'   => ' ',
                    'disabled'   => 'true'
                ),
                'label_attr' => array('id' => 'amla_sqrbundle_conformite_nomRaisonSocialeClient_lbl')
            ])
            /*->add('mobileMoney', ChoiceType::class, [
                'required' => false,
                'multiple'=>false,
                'expanded'=>false,
                'choices'  => [
                    'Avez vous un compte mobile money ?' => ' ',
                    'OUI' => 'OUI',
                    'NON' => 'NON',
                ],
                'label'=>' ',
            ])
            ->add('nom', TextType::class, [
                'required' => false,
                'label'=>'Nom',
                'attr'   =>  array(
                    'placeholder'   => 'Insérer votre nom'
                ),
                'label_attr' => array('id' => 'amla_sqrbundle_conformite_nom_lbl')
            ])
            ->add('telephone', TextType::class, [
                'required' => false,
                'label'=>'Téléphone',
                'attr'   =>  array(
                    'placeholder'   => 'Insérer votre numéro de téléphone'
                ),
                'label_attr' => array('id' => 'amla_sqrbundle_conformite_telephone_lbl')
            ])
            ->add('boitePostale', TextType::class, [
                'required' => false,
                'label'=>'Boite Postale',
                'attr'   =>  array(
                    'placeholder'   => 'Insérer votre boite postale'
                ),
                'label_attr' => array('id' => 'amla_sqrbundle_conformite_boitePostale_lbl')
            ])*/
            /* ->add('dateCreated')
            ->add('statut')*/
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Conformite'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_conformite';
    }


}
