<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;

class CautionType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('referenceMarche', TextType::class, array(
                'label' => 'Référence marché',
            ))
        ->add('typeCaution', ChoiceType::class, array(
                'required' => true,
                'label' => 'Type de caution',
                'multiple' => false,
                'expanded' => false,
                'choices'  => array(
                    'Sélectionner' => '',
                    'Caution pour soumission' => '0',// 
                    'Cautionnement définitif' => '1',//2%
                    'Caution de garantie' => '2',//10%
                    'Caution pour avance de démarrage' => '3',//30%
                ),
              //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
            ))
        ->add('dateDebutCaution', DateType::class, array(
                'label' => 'Date début',
                //'widget' => 'choice',
                'required' => false,
                'mapped'=>true,
                'required' => true,
                'widget' => 'single_text',
            ))
        ->add('dateFinCaution', DateType::class, array(
                'label' => 'Date fin ',
                //'widget' => 'choice',
                'required' => false,
                'mapped'=>true,
                'required' => true,
                'widget' => 'single_text',
            ))
        ->add('montantCaution', IntegerType ::class, array(
                'label' => 'Montant HT (FCFA)*',     
                'attr'=>array('min'=>0),
            ))
        ->add('contenuNumeric', TextareaType::class, array(
                'label' => 'Version numérique',
            ))
        ->add('pj', FileType::class, array(
                'data_class' => null,
                'label' => 'Scan document caution',
                'required' => true,
                'mapped'=>true,
            ))
        //->add('reference')
        //->add('dateCreated')
        //->add('account')
        ;
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Caution'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_caution';
    }


}
