<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class BonCommandeType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('libelleMarche')
        ->add('termeReference')
        ->add('dureeTravaux')
        ->add('prix')
        ->add('personneContacter')
        ->add('fournisseur')
        ->add('banque')
        ->add('termePaiement')

        ->add('cautionnement', CheckboxType::class, array(
            'label' => 'Cautionnement?',
            'required' => false,
        ))
        ->add('prixCautionnement', IntegerType::class, array(
            'label' => 'Montant du cautionnement',
            'required' => false,
        ));
        //->add('account')
        //->add('dateCreated');

        $builder->get('cautionnement')
            ->addModelTransformer(new CallbackTransformer(
                function ($property) {
                    return (bool) $property;
                },
                function ($property) {
                    return (bool) $property;
                }
            )
        );
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\BonCommande'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_boncommande';
    }


}
