<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;

class BanqueAssocieType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('institutionBancaire', EntityType::class, array(
                'class' => 'AMLASqrBundle:InstitutionBancaire',
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('r')
                        ->orderBy('r.nomBanque', 'ASC');
                },
                'choice_label' => function ($institutionbancaire) {
                    return $institutionbancaire->getNomBanque();
                },
                //'choice_label' => 'libelleRegion',
                'required' => true,
                'mapped' => true,
                'label' => 'Banque*',
                'placeholder' => 'Sélectionner',
            ))
            ->add('codeBanque')
            ->add('codeGuichet')
            ->add('numeroCompte', IntegerType ::class, array(
                'label' => 'Numéro de compte',                     
                'attr'=>array('min'=>0),
            ))
            ->add('cleRib', IntegerType ::class, array(
                'label' => 'Clé RIB',                     
                'attr'=>array('min'=>0),
            ))
            ->add('numeroIban', IntegerType ::class, array(
                'label' => 'Numéro IBAN',                     
                'attr'=>array('min'=>0),
            ))
            ->add('codeSwift')
            //->add('fournisseur')
            //->add('dateCreated')
        ;
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\BanqueAssocie'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_banqueassocie';
    }


}
