<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class AtdType2 extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            //->add('emeteur')
            ->add('misEnCause', TextType::class, array(
                'label' => 'NIU du redevable',
            ))
            ->add('nomMisEnCause', TextType::class, array(
                'label' => 'Nom du redevable*',
            ))
            ->add('montant', IntegerType ::class, array(
                'label' => 'Montant (FCFA)',                     
                'attr'=>array('min'=>0),
            ))
            /*->add('justificatif', FileType::class, array(
                'data_class' => null,
                'label' => 'Justificatif (PDF)',
                'required' => false,
            ))*/
            ->add('juridiction', TextType::class, array(
                'label' => 'Centre de compétence',
                'mapped'=>false,
            ))
            ->add('ville', TextType::class, array(
                'label' => 'Ville',
                'mapped'=>false,
            ))
            ->add('decisionJustice', FileType::class, array(
                'data_class' => null,
                'label' => 'Décision',
                'required' => true, 
                'mapped'=>false,
            ))
            ->add('dateDecision', DateType::class, array(
                'label' => 'Date de décision',
                //'widget' => 'choice',
                'required' => false,
                'mapped'=>false,
                'required' => true,
                'widget' => 'single_text',
            ))
            /*->add('dateCertificatNonAppel', DateType::class, array(
                'label' => 'Date certificat de non appel',
                //'widget' => 'choice',
                'required' => true,
                'widget' => 'single_text',
                'mapped'=>false,
            ))
            ->add('certificatNonAppel', FileType::class, array(
                'data_class' => null,
                'label' => 'Certificat de non appel',
                'required' => true,
                'mapped'=>false,
            ))*/
            ->add('critereDiffusion', ChoiceType::class, array(
                'required' => true,
                'label' => 'Critère de diffussion',
                'multiple' => false,
                'expanded' => false,
                'empty_data' => '0',
                'choices'  => array(
                    'Sélectionner' => '',
                    'Large diffussion' => '0',
                    'Notifier les partenaires uniquement' => '1',
                    'Notifier les banques uniquement' => '2',
                    'Notifier les banques et les partenaires' => '3',
                    'Aucune notification' => '4',
                ),
              //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
            )) 
        ;
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Atd'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_atd';
    }


}
