<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;

class AtdType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            //->add('emeteur')
            ->add('misEnCause', TextType::class, array(
                'label' => 'NIU du redevable*',
            ))
            ->add('nomMisEnCause', TextType::class, array(
                'label' => 'Nom du redevable*',
            ))
            ->add('montant', IntegerType ::class, array(
                'label' => 'Montant TTC (FCFA)*',     
                'attr'=>array('min'=>0),
            ))
            ->add('montantHt', IntegerType ::class, array(
                'label' => 'Montant HT (FCFA)*',     
                'attr'=>array('min'=>0),
            ))
            ->add('autoriteCompetente', TextareaType::class, array(
                'label' => 'Autorité compétente',
            ))
            ->add('telephoneAutorite', IntegerType ::class, array(
                'label' => 'N° téléphone autorité',
            ))
            ->add('emailAutorite', EmailType ::class, array(
                'label' => 'Email autorité',
            ))
            ->add('referenceDecision', TextType ::class, array(
                'label' => 'Référence de la décision',
            )) // centre de ratachem de la décision
            ->add('signataire', TextareaType::class, array(
                'label' => 'Signataires',
            ))
            ->add('dateDecision', DateType::class, array(
                'label' => 'Date de décision',
                //'widget' => 'choice',
                'required' => false,
                'mapped'=>false,
                'required' => true,
                'widget' => 'single_text',
            ))
            ->add('justificatif', FileType::class, array(
                'data_class' => null,
                'label' => 'Copie de la décision',
                'required' => false,
                'mapped'=>false,
            ))
            ->add('critereDiffusion', ChoiceType::class, array(
                'required' => true,
                'label' => 'Critère de diffussion',
                'multiple' => false,
                'expanded' => false,
                'empty_data' => '0',
                'choices'  => array(
                    'Sélectionner' => '',
                    'Large diffussion' => '0',
                    'Notifier les partenaires uniquement' => '1',
                    'Notifier les banques uniquement' => '2',
                    'Notifier les banques et les partenaires' => '3',
                    'Aucune notification' => '4',
                ),
              //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
            ))
            //->add('dateCreated')critereDiffusion
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Atd'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_atd';
    }


}
