<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class ApprovisionnerType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('type', ChoiceType::class, array(
            'required' => true,
            'label' => 'Approvisionner : *',
            'multiple' => false,
            'expanded' => false,
            'mapped'=>true,
            'choices'  => array(
                'Sélectionner...' => '',
                'Mon Compte FREEVENDING' => 'FREEVENDINGSELF',
                'Un autre Compte FREEVENDING' => 'FREEVENDINGELSE',
                'Orange Money (ORANGE)' => 'ORANGE',
                'Mobile Money (MTN)' => 'MTN',
            ),
            'attr'   =>  array(
                'class'   => 'typeApprovisionnement'
            ),
          //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        ->add('amount', IntegerType ::class, array(
            'label' => 'Montant à approvisionner*',
            'mapped'=>true,
            'attr'   =>  array(
                //'placeholder' => 'Insérer le montant de la transaction',
                'min'=>0,
                )
                //'size'=>"9",
        ))
        ->add('paymentMode', ChoiceType::class, array(
            'required' => true,
            'label' => 'Canal de paiement*',
            'multiple' => false,
            'expanded' => false,
            'mapped'=>true,
            'choices'  => array(
                'Sélectionner...' => '',
                'Compte FREEVENDING' => 'FREEVENDING',
                'Orange Money (ORANGE)' => 'ORANGE',
                'Mobile Money (MTN)' => 'MTN',
            ),
            'attr'   =>  array(
                'class'   => 'canalPaiement'
            ),
          //'placeholder' => 'Disposez vous d\'un aire de jeu ?'
        ))
        ->add('numberToPay', IntegerType ::class, array(
            'label' => 'Numéro à facturer*',
            'mapped'=>true,
            'required' => true,
            'attr'   =>  array(
                //'placeholder' => 'Insérer le montant de la transaction',
                'min'=>0,
                )
                //'size'=>"9",
        ))
        ->add('numberToBenefit', IntegerType ::class, array(
            'label' => 'Numéro du bénéficiaire*',
            'mapped'=>true,
            'required' => true,
            'label_attr' => array('id' => 'numberToBenefitLbl'),
            'attr'   =>  array(
                //'placeholder' => 'Insérer le montant de la transaction',
                'min'=>0,
                )
                //'size'=>"9",
        ))
        //->add('operator')
        //z->add('status')
        //->add('comment')
        //->add('dateCreated')
        //->add('fournisseur')
        //->add('account')
        ;
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Approvisionner'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_approvisionner';
    }


}
