<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\FileType;

class AnrType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('referenceANR', TextType::class, array(
            'label' => 'Référence ANR',
        ))
        ->add('dateDebut', DateType::class, array(
            'label' => 'Valable à partir du',
            //'widget' => 'choice',
            'required' => false,
            'widget' => 'single_text',
        ))
        ->add('fichier', FileType::class, array(
            'data_class' => null,
            'label' => 'SCAN ANR (PDF)',
            'required' => false,
        ))
        //->add('dateCreated')
        //->add('fournisseur')
        ;
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Anr'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_anr';
    }


}
