<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;

class ATDCantonneType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('numeroCantonnement', IntegerType ::class, array(
            'label' => 'Numéro de cantonnement*', 
        ))
        ->add('numeroAtd', IntegerType ::class, array(
            'label' => 'Numéro de l\'ATD*',  
        ))
        ->add('montant', IntegerType ::class, array(
            'label' => 'Montant*',     
            'attr'=>array('min'=>0),
        ))
        //->add('dateCantonnement')
        ->add('sourceCantonnement', TextType ::class, array(
            'label' => 'Source du cantonnement*',
        ))
        ->add('lieuCantonnement', TextType ::class, array(
            'label' => 'Lieu du cantonnement*',
        ))
        //->add('account')
        //->add('createdAt')
        //->add('referenceImpot')
        //->add('referenceChecktatoo')
        ;
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\ATDCantonne'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_atdcantonne';
    }


}
