<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * statutJuridique
 *
 * @ORM\Table(name="statut_juridique")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\statutJuridiqueRepository")
 */
class statutJuridique
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="intitule", type="string", length=255)
     */
    private $intitule;

    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;

    /**
     * @ORM\OneToMany(targetEntity="Fournissseur", mappedBy="formeJuridique")
     */
    private $fournisseur;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    function __construct(){
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set intitule
     *
     * @param string $intitule
     *
     * @return statutJuridique
     */
    public function setIntitule($intitule)
    {
        $this->intitule = $intitule;

        return $this;
    }

    /**
     * Get intitule
     *
     * @return string
     */
    public function getIntitule()
    {
        return $this->intitule;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return statutJuridique
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Add fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return statutJuridique
     */
    public function addFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur)
    {
        $this->fournisseur[] = $fournisseur;

        return $this;
    }

    /**
     * Remove fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     */
    public function removeFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur)
    {
        $this->fournisseur->removeElement($fournisseur);
    }

    /**
     * Get fournisseur
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return statutJuridique
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }
}
