<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Verification
 *
 * @ORM\Table(name="verification")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\VerificationRepository")
 */
class Verification
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="refAnr", type="string", length=255)
     */
    private $refAnr;

    /**
     * @var string
     *
     * @ORM\Column(name="niu", type="string", length=255)
     */
    private $niu;

    /**
     * @var string
     *
     * @ORM\Column(name="refBoncommande", type="string", length=255)
     */
    private $refBoncommande;

    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @var string
     *
     * @ORM\Column(name="account", type="string", length=255)
     */
    private $account;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set refAnr
     *
     * @param string $refAnr
     *
     * @return Verification
     */
    public function setRefAnr($refAnr)
    {
        $this->refAnr = $refAnr;

        return $this;
    }

    /**
     * Get refAnr
     *
     * @return string
     */
    public function getRefAnr()
    {
        return $this->refAnr;
    }

    /**
     * Set niu
     *
     * @param string $niu
     *
     * @return Verification
     */
    public function setNiu($niu)
    {
        $this->niu = $niu;

        return $this;
    }

    /**
     * Get niu
     *
     * @return string
     */
    public function getNiu()
    {
        return $this->niu;
    }

    /**
     * Set refBoncommande
     *
     * @param string $refBoncommande
     *
     * @return Verification
     */
    public function setRefBoncommande($refBoncommande)
    {
        $this->refBoncommande = $refBoncommande;

        return $this;
    }

    /**
     * Get refBoncommande
     *
     * @return string
     */
    public function getRefBoncommande()
    {
        return $this->refBoncommande;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return Verification
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Verification
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set account
     *
     * @param string $account
     *
     * @return Verification
     */
    public function setAccount($account)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return string
     */
    public function getAccount()
    {
        return $this->account;
    }
}
