<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TvaHistory
 *
 * @ORM\Table(name="tva_history")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\TvaHistoryRepository")
 */
class TvaHistory
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

   /**
     * @ORM\ManyToOne(targetEntity="FactureSpontane", inversedBy="tvaHistory")
     * @ORM\JoinColumn(name="facture_spontane_id", referencedColumnName="id")
     */
    private $factureSpontane;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="tvaHistory")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    /**
     * @var float
     *
     * @ORM\Column(name="montantTva", type="float")
     */
    private $montantTva;

    /**
     * @var float
     *
     * @ORM\Column(name="montantIs", type="float")
     */
    private $montantIs;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="tvaHistory")
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @var int
     *
     * @ORM\Column(name="statut", type="integer")
     */
    private $statut;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set facture
     *
     * @param integer $facture
     *
     * @return TvaHistory
     */
    public function setFacture($facture)
    {
        $this->facture = $facture;

        return $this;
    }

    /**
     * Get facture
     *
     * @return int
     */
    public function getFacture()
    {
        return $this->facture;
    }

    /**
     * Set tauxTva
     *
     * @param float $tauxTva
     *
     * @return TvaHistory
     */
    public function setTauxTva($tauxTva)
    {
        $this->tauxTva = $tauxTva;

        return $this;
    }

    /**
     * Get tauxTva
     *
     * @return float
     */
    public function getTauxTva()
    {
        return $this->tauxTva;
    }

    /**
     * Set montantIs
     *
     * @param float $montantIs
     *
     * @return TvaHistory
     */
    public function setMontantIs($montantIs)
    {
        $this->montantIs = $montantIs;

        return $this;
    }

    /**
     * Get montantIs
     *
     * @return float
     */
    public function getMontantIs()
    {
        return $this->montantIs;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return TvaHistory
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set fournisseur
     *
     * @param integer $fournisseur
     *
     * @return TvaHistory
     */
    public function setFournisseur($fournisseur)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return int
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return TvaHistory
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return int
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set montantTva
     *
     * @param float $montantTva
     *
     * @return TvaHistory
     */
    public function setMontantTva($montantTva)
    {
        $this->montantTva = $montantTva;

        return $this;
    }

    /**
     * Get montantTva
     *
     * @return float
     */
    public function getMontantTva()
    {
        return $this->montantTva;
    }

    /**
     * Set factureSpontane
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane
     *
     * @return TvaHistory
     */
    public function setFactureSpontane(\AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane = null)
    {
        $this->factureSpontane = $factureSpontane;

        return $this;
    }

    /**
     * Get factureSpontane
     *
     * @return \AMLA\SqrBundle\Entity\FactureSpontane
     */
    public function getFactureSpontane()
    {
        return $this->factureSpontane;
    }
}
