<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SubscriptionInbill
 *
 * @ORM\Table(name="subscription_inbill")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\SubscriptionInbillRepository")
 */
class SubscriptionInbill
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Inbill", inversedBy="subscriptionInbill")
     * @ORM\JoinColumn(name="inbill_id", referencedColumnName="id")
     */
    private $inbill;

    /**
     * @var int
     *
     * @ORM\Column(name="months", type="integer")
     */
    private $months;

    /**
     * @var float
     *
     * @ORM\Column(name="amount", type="float")
     */
    private $amount;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateStart", type="datetime")
     */
    private $dateStart;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateEnd", type="datetime")
     */
    private $dateEnd;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="subscriptionInbill")
     * @ORM\JoinColumn(name="account_id", referencedColumnName="id")
     */
    private $account;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 0;//0=En attente // 1= Payée // 2=rejetée (avec ou sans motif)
        $this->amount = "0";
    }

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set inbill.
     *
     * @param int $inbill
     *
     * @return SubscriptionInbill
     */
    public function setInbill($inbill)
    {
        $this->inbill = $inbill;

        return $this;
    }

    /**
     * Get inbill.
     *
     * @return int
     */
    public function getInbill()
    {
        return $this->inbill;
    }

    /**
     * Set months.
     *
     * @param int $months
     *
     * @return SubscriptionInbill
     */
    public function setMonths($months)
    {
        $this->months = $months;

        return $this;
    }

    /**
     * Get months.
     *
     * @return int
     */
    public function getMonths()
    {
        return $this->months;
    }

    /**
     * Set amount.
     *
     * @param float $amount
     *
     * @return SubscriptionInbill
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * Get amount.
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * Set dateStart.
     *
     * @param \DateTime $dateStart
     *
     * @return SubscriptionInbill
     */
    public function setDateStart($dateStart)
    {
        $this->dateStart = $dateStart;

        return $this;
    }

    /**
     * Get dateStart.
     *
     * @return \DateTime
     */
    public function getDateStart()
    {
        return $this->dateStart;
    }

    /**
     * Set dateEnd.
     *
     * @param \DateTime $dateEnd
     *
     * @return SubscriptionInbill
     */
    public function setDateEnd($dateEnd)
    {
        $this->dateEnd = $dateEnd;

        return $this;
    }

    /**
     * Get dateEnd.
     *
     * @return \DateTime
     */
    public function getDateEnd()
    {
        return $this->dateEnd;
    }

    /**
     * Set dateCreated.
     *
     * @param \DateTime $dateCreated
     *
     * @return SubscriptionInbill
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated.
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set account.
     *
     * @param int $account
     *
     * @return SubscriptionInbill
     */
    public function setAccount($account)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account.
     *
     * @return int
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Set status.
     *
     * @param int $status
     *
     * @return SubscriptionInbill
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status.
     *
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }
}
