<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SoummissionOffre
 *
 * @ORM\Table(name="soummission_offre")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\SoummissionOffreRepository")
 */
class SoummissionOffre
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Offre", inversedBy="soumissionoffre")
     * @ORM\JoinColumn(name="offre_id", referencedColumnName="id", nullable=true)
     */
    private $offre;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="soumissionoffre")
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur;

    
    /**
     * @ORM\ManyToOne(targetEntity="Anr", inversedBy="soumissionoffre")
     * @ORM\JoinColumn(name="anr_id", referencedColumnName="id", nullable=true)
     */
    private $anr;

    /**
     * @ORM\ManyToOne(targetEntity="Atd", inversedBy="soumissionoffre")
     * @ORM\JoinColumn(name="atd_id", referencedColumnName="id", nullable=true)
     */
    private $atd;

    /**
     * @ORM\OneToMany(targetEntity="Document", mappedBy="soumission")
     */
    private $documents;

    /**
     * @ORM\OneToMany(targetEntity="Annexe", mappedBy="soumission")
     */
    private $annexes;

    /**
     * @ORM\OneToMany(targetEntity="Administratif", mappedBy="soumission")
     */
    private $administratifs;

    /**
     * @ORM\OneToMany(targetEntity="Financier", mappedBy="soumission")
     */
    private $financiers;

    /**
     * @ORM\OneToMany(targetEntity="Technique", mappedBy="soumission")
     */
    private $techniques;

    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     * {0 = non validé, 1 = validé}
     */
    private $statut;

    /**
     * @var int
     *
     * @ORM\Column(name="price", type="integer", nullable=true)
     */
    private $price;

    /**
     * @var string
     *
     * @ORM\Column(name="commentaires", type="string", nullable=true)
     */
    private $commentaires;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\OneToMany(targetEntity="BonCommande", mappedBy="soummissionOffre")
    */
    private $bonCommande;

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set offre
     *
     * @param integer $offre
     *
     * @return SoummissionOffre
     */
    public function setOffre($offre)
    {
        $this->offre = $offre;

        return $this;
    }

    /**
     * Get offre
     *
     * @return int
     */
    public function getOffre()
    {
        return $this->offre;
    }

    /**
     * Set fournisseur
     *
     * @param integer $fournisseur
     *
     * @return SoummissionOffre
     */
    public function setFournisseur($fournisseur)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return int
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set status
     *
     * @param string $status
     *
     * @return SoummissionOffre
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return SoummissionOffre
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    public function __construct()
    {
        date_default_timezone_set( 'Africa/Douala' );
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;
    }


    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return SoummissionOffre
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set price
     *
     * @param integer $price
     *
     * @return SoummissionOffre
     */
    public function setPrice($price)
    {
        $this->price = $price;

        return $this;
    }

    /**
     * Get price
     *
     * @return integer
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Set anr
     *
     * @param \AMLA\SqrBundle\Entity\Anr $anr
     *
     * @return SoummissionOffre
     */
    public function setAnr(\AMLA\SqrBundle\Entity\Anr $anr = null)
    {
        $this->anr = $anr;

        return $this;
    }

    /**
     * Get anr
     *
     * @return \AMLA\SqrBundle\Entity\Anr
     */
    public function getAnr()
    {
        return $this->anr;
    }

    /**
     * Set atd
     *
     * @param \AMLA\SqrBundle\Entity\Atd $atd
     *
     * @return SoummissionOffre
     */
    public function setAtd(\AMLA\SqrBundle\Entity\Atd $atd = null)
    {
        $this->atd = $atd;

        return $this;
    }

    /**
     * Get atd
     *
     * @return \AMLA\SqrBundle\Entity\Atd
     */
    public function getAtd()
    {
        return $this->atd;
    }

    /**
     * Add bonCommande
     *
     * @param \AMLA\SqrBundle\Entity\BonCommande $bonCommande
     *
     * @return SoummissionOffre
     */
    public function addBonCommande(\AMLA\SqrBundle\Entity\BonCommande $bonCommande)
    {
        $this->bonCommande[] = $bonCommande;

        return $this;
    }

    /**
     * Remove bonCommande
     *
     * @param \AMLA\SqrBundle\Entity\BonCommande $bonCommande
     */
    public function removeBonCommande(\AMLA\SqrBundle\Entity\BonCommande $bonCommande)
    {
        $this->bonCommande->removeElement($bonCommande);
    }

    /**
     * Get bonCommande
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBonCommande()
    {
        return $this->bonCommande;
    }

    /**
     * Add document
     *
     * @param \AMLA\SqrBundle\Entity\Document $document
     *
     * @return SoummissionOffre
     */
    public function addDocument(\AMLA\SqrBundle\Entity\Document $document)
    {
        $this->documents[] = $document;

        return $this;
    }

    /**
     * Remove document
     *
     * @param \AMLA\SqrBundle\Entity\Document $document
     */
    public function removeDocument(\AMLA\SqrBundle\Entity\Document $document)
    {
        $this->documents->removeElement($document);
    }

    /**
     * Get documents
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDocuments()
    {
        return $this->documents;
    }

    /**
     * Set commentaires
     *
     * @param string $commentaires
     *
     * @return SoummissionOffre
     */
    public function setCommentaires($commentaires)
    {
        $this->commentaires = $commentaires;

        return $this;
    }

    /**
     * Get commentaires
     *
     * @return string
     */
    public function getCommentaires()
    {
        return $this->commentaires;
    }

    /**
     * Set fournisseurSpon
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseurSpon
     *
     * @return SoummissionOffre
     */
    public function setFournisseurSpon(\AMLA\SqrBundle\Entity\Fournissseur $fournisseurSpon = null)
    {
        $this->fournisseurSpon = $fournisseurSpon;

        return $this;
    }

    /**
     * Get fournisseurSpon
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseurSpon()
    {
        return $this->fournisseurSpon;
    }

    /**
     * Add annex
     *
     * @param \AMLA\SqrBundle\Entity\Annexe $annex
     *
     * @return SoummissionOffre
     */
    public function addAnnex(\AMLA\SqrBundle\Entity\Annexe $annex)
    {
        $this->annexes[] = $annex;

        return $this;
    }

    /**
     * Remove annex
     *
     * @param \AMLA\SqrBundle\Entity\Annexe $annex
     */
    public function removeAnnex(\AMLA\SqrBundle\Entity\Annexe $annex)
    {
        $this->annexes->removeElement($annex);
    }

    /**
     * Get annexes
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAnnexes()
    {
        return $this->annexes;
    }

    /**
     * Add administratif
     *
     * @param \AMLA\SqrBundle\Entity\Administratif $administratif
     *
     * @return SoummissionOffre
     */
    public function addAdministratif(\AMLA\SqrBundle\Entity\Administratif $administratif)
    {
        $this->administratifs[] = $administratif;

        return $this;
    }

    /**
     * Remove administratif
     *
     * @param \AMLA\SqrBundle\Entity\Administratif $administratif
     */
    public function removeAdministratif(\AMLA\SqrBundle\Entity\Administratif $administratif)
    {
        $this->administratifs->removeElement($administratif);
    }

    /**
     * Get administratifs
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAdministratifs()
    {
        return $this->administratifs;
    }

    /**
     * Add financier
     *
     * @param \AMLA\SqrBundle\Entity\Financier $financier
     *
     * @return SoummissionOffre
     */
    public function addFinancier(\AMLA\SqrBundle\Entity\Financier $financier)
    {
        $this->financiers[] = $financier;

        return $this;
    }

    /**
     * Remove financier
     *
     * @param \AMLA\SqrBundle\Entity\Financier $financier
     */
    public function removeFinancier(\AMLA\SqrBundle\Entity\Financier $financier)
    {
        $this->financiers->removeElement($financier);
    }

    /**
     * Get financiers
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFinanciers()
    {
        return $this->financiers;
    }

    /**
     * Add technique
     *
     * @param \AMLA\SqrBundle\Entity\Technique $technique
     *
     * @return SoummissionOffre
     */
    public function addTechnique(\AMLA\SqrBundle\Entity\Technique $technique)
    {
        $this->techniques[] = $technique;

        return $this;
    }

    /**
     * Remove technique
     *
     * @param \AMLA\SqrBundle\Entity\Technique $technique
     */
    public function removeTechnique(\AMLA\SqrBundle\Entity\Technique $technique)
    {
        $this->techniques->removeElement($technique);
    }

    /**
     * Get techniques
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getTechniques()
    {
        return $this->techniques;
    }
}
