<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ServiceItem
 *
 * @ORM\Table(name="service_item")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\ServiceItemRepository")
 */
class ServiceItem
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="codification", type="string", length=255)
     */
    private $codification;

    /**
     * @ORM\ManyToOne(targetEntity="ServiceCategory", inversedBy="serviceItem")
     * @ORM\JoinColumn(name="service_category_id", referencedColumnName="id")
     */
    private $serviceCategory;

    /**
     * @var string
     *
     * @ORM\Column(name="intitule", type="string", length=255)
     */
    private $intitule;

    /**
     * @var float
     *
     * @ORM\Column(name="amount", type="float")
     */
    private $amount;

    /**
     * @ORM\OneToMany(targetEntity="ServiceArticle", mappedBy="serviceItem")
    */
    private $serviceArticle;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->serviceArticle = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codification
     *
     * @param string $codification
     *
     * @return ServiceItem
     */
    public function setCodification($codification)
    {
        $this->codification = $codification;

        return $this;
    }

    /**
     * Get codification
     *
     * @return string
     */
    public function getCodification()
    {
        return $this->codification;
    }

    /**
     * Set intitule
     *
     * @param string $intitule
     *
     * @return ServiceItem
     */
    public function setIntitule($intitule)
    {
        $this->intitule = $intitule;

        return $this;
    }

    /**
     * Get intitule
     *
     * @return string
     */
    public function getIntitule()
    {
        return $this->intitule;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return ServiceItem
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set amount
     *
     * @param float $amount
     *
     * @return ServiceItem
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * Get amount
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * Set serviceCategory
     *
     * @param \AMLA\SqrBundle\Entity\ServiceCategory $serviceCategory
     *
     * @return ServiceItem
     */
    public function setServiceCategory(\AMLA\SqrBundle\Entity\ServiceCategory $serviceCategory = null)
    {
        $this->serviceCategory = $serviceCategory;

        return $this;
    }

    /**
     * Get serviceCategory
     *
     * @return \AMLA\SqrBundle\Entity\ServiceCategory
     */
    public function getServiceCategory()
    {
        return $this->serviceCategory;
    }

    /**
     * Add serviceArticle
     *
     * @param \AMLA\SqrBundle\Entity\ServiceArticle $serviceArticle
     *
     * @return ServiceItem
     */
    public function addServiceArticle(\AMLA\SqrBundle\Entity\ServiceArticle $serviceArticle)
    {
        $this->serviceArticle[] = $serviceArticle;

        return $this;
    }

    /**
     * Remove serviceArticle
     *
     * @param \AMLA\SqrBundle\Entity\ServiceArticle $serviceArticle
     */
    public function removeServiceArticle(\AMLA\SqrBundle\Entity\ServiceArticle $serviceArticle)
    {
        $this->serviceArticle->removeElement($serviceArticle);
    }

    /**
     * Get serviceArticle
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getServiceArticle()
    {
        return $this->serviceArticle;
    }
}
