<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ServiceCategory
 *
 * @ORM\Table(name="service_category")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\ServiceCategoryRepository")
 */
class ServiceCategory
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="codification", type="string", length=50)
     */
    private $codification;

    /**
     * @var string
     *
     * @ORM\Column(name="intitule", type="string", length=255)
     */
    private $intitule;

    /**
     * @ORM\OneToMany(targetEntity="ServiceItem", mappedBy="serviceCategory")
    */
    private $serviceItem;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->serviceItem = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codification
     *
     * @param string $codification
     *
     * @return ServiceCategory
     */
    public function setCodification($codification)
    {
        $this->codification = $codification;

        return $this;
    }

    /**
     * Get codification
     *
     * @return string
     */
    public function getCodification()
    {
        return $this->codification;
    }

    /**
     * Set intitule
     *
     * @param string $intitule
     *
     * @return ServiceCategory
     */
    public function setIntitule($intitule)
    {
        $this->intitule = $intitule;

        return $this;
    }

    /**
     * Get intitule
     *
     * @return string
     */
    public function getIntitule()
    {
        return $this->intitule;
    }

    /**
     * Add serviceItem
     *
     * @param \AMLA\SqrBundle\Entity\ServiceItem $serviceItem
     *
     * @return ServiceCategory
     */
    public function addServiceItem(\AMLA\SqrBundle\Entity\ServiceItem $serviceItem)
    {
        $this->serviceItem[] = $serviceItem;

        return $this;
    }

    /**
     * Remove serviceItem
     *
     * @param \AMLA\SqrBundle\Entity\ServiceItem $serviceItem
     */
    public function removeServiceItem(\AMLA\SqrBundle\Entity\ServiceItem $serviceItem)
    {
        $this->serviceItem->removeElement($serviceItem);
    }

    /**
     * Get serviceItem
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getServiceItem()
    {
        return $this->serviceItem;
    }
}
