<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ServiceArticle
 *
 * @ORM\Table(name="service_article")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\ServiceArticleRepository")
 */
class ServiceArticle
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Service", inversedBy="serviceArticle")
     * @ORM\JoinColumn(name="service_id", referencedColumnName="id")
     */
    private $service;

    /**
     * @ORM\ManyToOne(targetEntity="ServiceItem", inversedBy="serviceArticle")
     * @ORM\JoinColumn(name="service_item_id", referencedColumnName="id")
     */
    private $serviceItem;

    /**
     * @var int
     *
     * @ORM\Column(name="quantity", type="integer")
     */
    private $quantity;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set quantity
     *
     * @param integer $quantity
     *
     * @return ServiceArticle
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;

        return $this;
    }

    /**
     * Get quantity
     *
     * @return integer
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return ServiceArticle
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set service
     *
     * @param \AMLA\SqrBundle\Entity\Service $service
     *
     * @return ServiceArticle
     */
    public function setService(\AMLA\SqrBundle\Entity\Service $service = null)
    {
        $this->service = $service;

        return $this;
    }

    /**
     * Get service
     *
     * @return \AMLA\SqrBundle\Entity\Service
     */
    public function getService()
    {
        return $this->service;
    }

    /**
     * Set serviceItem
     *
     * @param \AMLA\SqrBundle\Entity\ServiceItem $serviceItem
     *
     * @return ServiceArticle
     */
    public function setServiceItem(\AMLA\SqrBundle\Entity\ServiceItem $serviceItem = null)
    {
        $this->serviceItem = $serviceItem;

        return $this;
    }

    /**
     * Get serviceItem
     *
     * @return \AMLA\SqrBundle\Entity\ServiceItem
     */
    public function getServiceItem()
    {
        return $this->serviceItem;
    }
}
